/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.locationResolving;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Url;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/FileUrlMapping;", "", "url", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolvedWithFullName", "", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "(Lcom/intellij/util/Url;Lcom/intellij/openapi/vfs/VirtualFile;ZLjava/lang/String;Lorg/jetbrains/debugger/Script;)V", "contentHashCode", "", "getContentHashCode", "()I", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "fileOrFsModificationStamp", "", "getFileOrFsModificationStamp", "()J", "resolvedWithContent", "getResolvedWithContent", "()Z", "getResolvedWithFullName", "resolvedWithScript", "getResolvedWithScript", "scriptHashCode", "getScriptHashCode", "getUrl", "()Lcom/intellij/util/Url;", "intellij.javascript.debugger"})
final class FileUrlMapping {
    private final long fileOrFsModificationStamp;
    private final boolean resolvedWithContent;
    private final int contentHashCode;
    private final boolean resolvedWithScript;
    private final int scriptHashCode;
    @NotNull
    private final Url url;
    @Nullable
    private final VirtualFile file;
    private final boolean resolvedWithFullName;

    public final long getFileOrFsModificationStamp() {
        return this.fileOrFsModificationStamp;
    }

    public final boolean getResolvedWithContent() {
        return this.resolvedWithContent;
    }

    public final int getContentHashCode() {
        return this.contentHashCode;
    }

    public final boolean getResolvedWithScript() {
        return this.resolvedWithScript;
    }

    public final int getScriptHashCode() {
        return this.scriptHashCode;
    }

    @NotNull
    public final Url getUrl() {
        return this.url;
    }

    @Nullable
    public final VirtualFile getFile() {
        return this.file;
    }

    public final boolean getResolvedWithFullName() {
        return this.resolvedWithFullName;
    }

    public FileUrlMapping(@NotNull Url url, @Nullable VirtualFile file, boolean resolvedWithFullName, @Nullable String sourceContent, @Nullable Script script) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.url = url;
        this.file = file;
        this.resolvedWithFullName = resolvedWithFullName;
        VirtualFile virtualFile = this.file;
        if (virtualFile != null) {
            l = virtualFile.getModificationStamp();
        } else {
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
            l = virtualFileManager.getStructureModificationCount();
        }
        this.fileOrFsModificationStamp = l;
        this.resolvedWithContent = sourceContent != null;
        String string = sourceContent;
        this.contentHashCode = string != null ? string.hashCode() : 0;
        this.resolvedWithScript = script != null;
        Script script2 = script;
        this.scriptHashCode = script2 != null ? script2.hashCode() : 0;
    }
}

