/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.scripts.ConsumerOnEdt;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.ScriptTreeActionBase;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.javascript.debugger.scripts.SourcesTreeComponent;
import com.intellij.javascript.debugger.scripts.VisualizeScriptSourcemap$visualize$;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceFileFinder;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapActionKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0014J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/debugger/scripts/VisualizeScriptSourcemap;", "Lcom/intellij/javascript/debugger/scripts/ScriptTreeActionBase;", "treeComponent", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "(Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;)V", "invisibleIfDisabled", "", "getInvisibleIfDisabled", "()Z", "chooseScript", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/Script;", "items", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isApplicable", "info", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "perform", "", "node", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "context", "visualize", "script", "sourceUrl", "Lcom/intellij/util/Url;", "intellij.javascript.debugger"})
public final class VisualizeScriptSourcemap
extends ScriptTreeActionBase {
    private final boolean invisibleIfDisabled = false;

    @Override
    protected boolean getInvisibleIfDisabled() {
        return this.invisibleIfDisabled;
    }

    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        for (Script script : info.getScripts$intellij_javascript_debugger()) {
            if (script.getSourceMap() == null) continue;
            return true;
        }
        return false;
    }

    private final Promise<Script> chooseScript(List<? extends Script> items, DataContext dataContext) {
        if (items.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first(items));
        }
        AsyncPromise result2 = new AsyncPromise();
        JBPopupFactory.getInstance().createPopupChooserBuilder(items).setTitle("Choose Script").setItemChosenCallback((Consumer)new Consumer<Script>(result2){
            final /* synthetic */ AsyncPromise $result;

            public final void consume(Script value) {
                Script script = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)script, (String)"value");
                this.$result.setResult((Object)script);
            }
            {
                this.$result = asyncPromise;
            }
        }).setRenderer((ListCellRenderer)new ColoredListCellRenderer<Script>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Script> list, @NotNull Script value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull(list, (String)"list");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                this.setIcon(ScriptsKt.getFileType(value.getUrl()).getIcon());
                this.append(value.getUrl().toDecodedForm());
            }
        }).createPopup().showInBestPositionFor(dataContext);
        return (Promise)result2;
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)node), (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Url sourceUrl = node.getFileInfo().getUrl();
        this.chooseScript(node.getFileInfo().getScripts$intellij_javascript_debugger(), context).onSuccess((java.util.function.Consumer)new java.util.function.Consumer<Script>(this, sourceUrl){
            final /* synthetic */ VisualizeScriptSourcemap this$0;
            final /* synthetic */ Url $sourceUrl;

            public final void accept(Script script) {
                Script script2 = script;
                Intrinsics.checkExpressionValueIsNotNull((Object)script2, (String)"script");
                VisualizeScriptSourcemap.access$visualize(this.this$0, script2, this.$sourceUrl);
            }
            {
                this.this$0 = visualizeScriptSourcemap;
                this.$sourceUrl = url;
            }
        });
    }

    private final void visualize(Script script, Url sourceUrl) {
        block1: {
            Vm vm;
            Vm activeOrMainVm;
            SourceMap sourceMap = script.getSourceMap();
            if (sourceMap == null) {
                return;
            }
            SourceMap map = sourceMap;
            JavaScriptDebuggerViewSupport viewSupport = this.getTreeComponent().getDebugProcess().getDebuggerViewSupport();
            Vm vm2 = activeOrMainVm = viewSupport.getDebugProcess().getActiveOrMainVm();
            if (vm2 == null) break block1;
            Vm it = vm = vm2;
            viewSupport.getFileByUrlOrVmSource(activeOrMainVm, script, true).onSuccess((java.util.function.Consumer)new ConsumerOnEdt<VirtualFile>(this.getProject(), this, viewSupport, activeOrMainVm, script, map, sourceUrl){
                final /* synthetic */ VisualizeScriptSourcemap this$0;
                final /* synthetic */ JavaScriptDebuggerViewSupport $viewSupport$inlined;
                final /* synthetic */ Vm $activeOrMainVm$inlined;
                final /* synthetic */ Script $script$inlined;
                final /* synthetic */ SourceMap $map$inlined;
                final /* synthetic */ Url $sourceUrl$inlined;
                {
                    this.this$0 = visualizeScriptSourcemap;
                    this.$viewSupport$inlined = javaScriptDebuggerViewSupport;
                    this.$activeOrMainVm$inlined = vm;
                    this.$script$inlined = script;
                    this.$map$inlined = sourceMap;
                    this.$sourceUrl$inlined = url;
                    super($super_call_param$1);
                }

                public void consume(@NotNull Project project, @NotNull VirtualFile file) {
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    VisualizeSourceMapActionKt.visualizeMap(this.$map$inlined, file, this.$sourceUrl$inlined, project, new SourceFileFinder(this){
                        final /* synthetic */ visualize$$inlined$let$lambda$1 this$0;
                        {
                            this.this$0 = $outer;
                        }

                        @Nullable
                        public VirtualFile find(@NotNull Url source) {
                            VirtualFile virtualFile;
                            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                            VirtualFile virtualFile2 = SourceMapInspectorKt.createSourceFromProvidedContent(this.this$0.$map$inlined, source, (UserDataHolder)this.this$0.$script$inlined);
                            if (virtualFile2 == null) {
                                virtualFile2 = virtualFile = SourceMapInspectorKt.getSourceFile(source);
                            }
                            if (virtualFile2 == null) {
                                virtualFile = this.this$0.this$0.getTreeComponent().getDebugProcess().findFileOrAny(source);
                            }
                            return virtualFile;
                        }
                    });
                }
            });
        }
    }

    public VisualizeScriptSourcemap(@NotNull SourcesTreeComponent treeComponent) {
        Intrinsics.checkParameterIsNotNull((Object)treeComponent, (String)"treeComponent");
        super(treeComponent, "Visualize Source Map");
    }

    public static final /* synthetic */ void access$visualize(VisualizeScriptSourcemap $this, @NotNull Script script, @NotNull Url sourceUrl) {
        $this.visualize(script, sourceUrl);
    }
}

