/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.AddSourceContentsActionKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/AddSourceContentsAction;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction;", "()V", "perform", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger"})
public final class AddSourceContentsAction
extends BaseSourceMapAction {
    @Override
    protected void perform(@NotNull SourceMap sourceMap, @NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(file, project, sourceMap, project, "Add sources content to " + SourceMapInspectorKt.getFileTitle(file), true){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ SourceMap $sourceMap;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                String string;
                File file;
                String path;
                CharSequence charSequence;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                InputStreamReader reader = new InputStreamReader(this.$file.getInputStream(), CharsetToolkit.UTF8_CHARSET);
                Map map = (Map)gson.fromJson((Reader)reader, (Type)((Object)Map.class));
                reader.close();
                if (map.containsKey("sourcesContent")) {
                    AddSourceContentsActionKt.access$getNOTIFICATION_GROUP$p().createNotification("Source Map has already sources content", MessageType.INFO).notify(this.$project);
                    return;
                }
                V v = map.get("sources");
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                List sources = (List)v;
                int size$iv = sources.size();
                Object[] result$iv = new String[size$iv];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    void it;
                    void i$iv;
                    void var11_14 = i$iv;
                    void var17_18 = i$iv;
                    object = result$iv;
                    VirtualFile virtualFile = SourceMapInspectorKt.getSourceFile(this.$sourceMap.getSources()[it]);
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    charSequence = VfsUtilCore.loadText((VirtualFile)virtualFile);
                    object[var17_18] = charSequence;
                    ++i$iv;
                }
                Object[] sourcesContent = result$iv;
                map.put("sourcesContent", ArraysKt.toList((Object[])sourcesContent));
                String string2 = path = this.$file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
                int index = StringsKt.lastIndexOf$default((CharSequence)string2, (String)".map", (int)0, (boolean)false, (int)6, null);
                String ext = ".source.map";
                File file2 = file;
                Object object2 = file;
                CharSequence charSequence2 = new StringBuilder();
                if (index > -1) {
                    String it = path;
                    int n3 = 0;
                    charSequence = charSequence2;
                    File file3 = file2;
                    object = object2;
                    String string3 = it.substring(n3, index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string4 = string3;
                    object2 = object;
                    file2 = file3;
                    charSequence2 = charSequence;
                    string = string4;
                } else {
                    string = path;
                }
                file2(charSequence2.append(string).append(ext).toString());
                File outFile = object2;
                OutputStreamWriter stream = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), CharsetToolkit.UTF8_CHARSET);
                Closeable closeable = stream;
                Throwable throwable = null;
                try {
                    OutputStreamWriter it = (OutputStreamWriter)closeable;
                    gson.toJson((Object)map, (Appendable)it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outFile);
                AddSourceContentsActionKt.access$getNOTIFICATION_GROUP$p().createNotification("Source Map with sources content created: " + outFile.getName(), MessageType.INFO).notify(this.$project);
            }
            {
                this.$file = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$sourceMap = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }
}

