/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskRepository;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class SendTimeTrackingInformationDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.timeTracking.TasksToolWindowPanel");
    private static final Pattern PATTERN = Pattern.compile("([0-9]+)h ([0-9]+)m");
    @Nullable
    private final Project myProject;
    private final LocalTask myTask;
    private JRadioButton myFromPreviousPostRadioButton;
    private JRadioButton myTotallyRadioButton;
    private JRadioButton myCustomRadioButton;
    private JTextField myFromPreviousPostTextField;
    private JTextField myTotallyTextField;
    private JTextField myCustomTextField;
    private JTextArea myCommentTextArea;
    private JPanel myPanel;
    private JLabel myTaskNameLabel;

    protected SendTimeTrackingInformationDialog(@Nullable Project project, LocalTask localTask) {
        super(project);
        this.myProject = project;
        this.myTask = localTask;
        this.$$$setupUI$$$();
        this.setTitle("Time Tracking");
        this.myTaskNameLabel.setText(this.myTask.getPresentableName());
        this.myFromPreviousPostRadioButton.setSelected(true);
        if (this.myTask.getLastPost() == null) {
            this.myFromPreviousPostRadioButton.setVisible(false);
            this.myFromPreviousPostTextField.setVisible(false);
            this.myTotallyRadioButton.setSelected(true);
        }
        this.myFromPreviousPostTextField.setText(SendTimeTrackingInformationDialog.formatDuration(this.myTask.getTimeSpentFromLastPost()));
        this.myTotallyTextField.setText(SendTimeTrackingInformationDialog.formatDuration(this.myTask.getTotalTimeSpent()));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public static String formatDuration(long milliseconds) {
        int second = 1000;
        int minute = 60000;
        int hour = 3600000;
        int hours = (int)(milliseconds / 3600000L);
        int minutes = (int)(milliseconds % 3600000L / 60000L);
        String hoursString = hours + "h ";
        String minutesString = minutes + "m";
        return hoursString + minutesString;
    }

    protected void doOKAction() {
        String timeSpentText = this.myFromPreviousPostRadioButton.isSelected() ? this.myFromPreviousPostTextField.getText() : (this.myTotallyRadioButton.isSelected() ? this.myTotallyTextField.getText() : this.myCustomTextField.getText());
        Matcher matcher = PATTERN.matcher(timeSpentText);
        if (matcher.matches()) {
            int timeSpent = Integer.valueOf(matcher.group(1)) * 60 + Integer.valueOf(matcher.group(2));
            TaskRepository repository = this.myTask.getRepository();
            if (repository == null || !repository.isSupported(4)) {
                LOG.error("Time management not supported: " + repository);
                return;
            }
            try {
                repository.updateTimeSpent(this.myTask, timeSpentText, this.myCommentTextArea.getText());
                this.myTask.setLastPost(new Date());
            }
            catch (Exception e1) {
                Messages.showErrorDialog((Project)this.myProject, (String)("<html>Could not send information for " + this.myTask.getPresentableName() + "<br/>" + e1.getMessage()), (String)"Error");
                LOG.warn((Throwable)e1);
            }
        }
        super.doOKAction();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String timeSpentText;
        String string = this.myFromPreviousPostRadioButton.isSelected() ? this.myFromPreviousPostTextField.getText() : (timeSpentText = this.myTotallyRadioButton.isSelected() ? this.myTotallyTextField.getText() : this.myCustomTextField.getText());
        if (!PATTERN.matcher(timeSpentText).matches()) {
            return new ValidationInfo("Time Spent has broken format");
        }
        return null;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "com.intellij.tasks.timeTracking.TasksToolWindowPanel";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JRadioButton jRadioButton;
        JTextField jTextField2;
        JTextField jTextField3;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JTextArea jTextArea;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Issue:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Comment:");
        jBLabel2.setDisplayedMnemonic('C');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jBLabel2.setToolTipText("");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myTaskNameLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myCommentTextArea = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(5, 0, 5, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myFromPreviousPostRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("From previous post:");
        jRadioButton3.setMnemonic('P');
        jRadioButton3.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jRadioButton3, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Custom:");
        jRadioButton2.setMnemonic('M');
        jRadioButton2.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFromPreviousPostTextField = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel2.add((Component)jTextField3, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCustomTextField = jTextField2 = new JTextField();
        jTextField2.setText("0h 0m");
        jPanel2.add((Component)jTextField2, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myTotallyRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Totally:");
        jRadioButton.setMnemonic('Y');
        jRadioButton.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTotallyTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Time Spent:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

