/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client.jaxrs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.client.utils.JsonHelper;
import com.microsoft.visualstudio.services.webapi.model.VssJsonCollectionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

public class ApiResourceEntityProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    public long getSize(Object entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public void writeTo(Object entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ObjectMapper objectMapper = JsonHelper.getObjectMapper();
        JsonGenerator jsonGenerator = objectMapper.getFactory().createGenerator(entityStream);
        jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        jsonGenerator.writeObject(entity);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.getType().equalsIgnoreCase("application") && mediaType.getSubtype().equalsIgnoreCase("json");
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ObjectMapper objectMapper = JsonHelper.getObjectMapper();
        JsonParser jsonParser = objectMapper.getFactory().createParser(entityStream);
        jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        if (genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getRawType() == List.class) {
            JavaType rootType = objectMapper.getTypeFactory().constructParametricType(VssJsonCollectionWrapper.class, new JavaType[]{objectMapper.constructType(genericType)});
            VssJsonCollectionWrapper result = (VssJsonCollectionWrapper)objectMapper.readValue(jsonParser, rootType);
            return result.getValue();
        }
        return objectMapper.readValue(jsonParser, objectMapper.constructType(genericType));
    }
}

