/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.services;

import com.microsoft.alm.plugin.idea.common.settings.TeamServicesSettingsService;
import com.microsoft.alm.plugin.services.PropertyService;
import java.util.Collections;
import java.util.Map;

public class PropertyServiceImpl
implements PropertyService {
    private boolean restored = false;
    private Map<String, String> map;

    protected PropertyServiceImpl() {
    }

    public static PropertyServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    public String getProperty(String propertyName) {
        this.ensureRestored();
        return this.map.get(propertyName);
    }

    public void setProperty(String propertyName, String value) {
        this.ensureRestored();
        if (value == null) {
            this.removeProperty(propertyName);
        } else {
            this.map.put(propertyName, value);
        }
    }

    public void removeProperty(String propertyName) {
        if (this.map.containsKey(propertyName)) {
            this.map.remove(propertyName);
        }
    }

    public Map<String, String> getProperties() {
        if (this.map == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.map);
    }

    private void ensureRestored() {
        if (!this.restored) {
            this.restored = true;
            this.map = TeamServicesSettingsService.getInstance().restoreProperties();
        }
    }

    private static class Holder {
        private static PropertyServiceImpl INSTANCE = new PropertyServiceImpl();

        private Holder() {
        }
    }
}

