/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.setup;

import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacStartup {
    private static final Logger logger = LoggerFactory.getLogger(MacStartup.class);
    protected static final String APP_NAME = "vsoi.app/";
    protected static final String OS_X_DIR = "osx";
    private static final String APPLET_PATH = "Contents/MacOS/applet";
    private static final String OPEN_CMD = "open";

    public static void startup() {
        MacStartup.setupProtocolHandlerUri();
    }

    protected static void setupProtocolHandlerUri() {
        try {
            String appPath = IdeaHelper.getResourcePath(MacStartup.class.getResource("/"), APP_NAME, OS_X_DIR);
            IdeaHelper.setExecutablePermissions(new File(appPath + APPLET_PATH));
            Process process = Runtime.getRuntime().exec(new String[]{OPEN_CMD, appPath});
            process.waitFor();
            logger.debug("The return code for executing {} was {}", (Object)APP_NAME, (Object)process.exitValue());
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("An UnsupportedEncodingException was caught while trying to execute {}: {}", (Object)APP_NAME, (Object)e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.warn("A FileNotFoundException was caught while trying to execute {}: {}", (Object)APP_NAME, (Object)e.getMessage());
        }
        catch (IOException e) {
            logger.warn("An IOException was caught while trying to execute {}: {}", (Object)APP_NAME, (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.warn("An Exception was caught while trying to find and execute {}: {}", (Object)APP_NAME, (Object)e.getMessage());
        }
    }
}

