/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.setup;

import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowsStartup {
    private static final Logger logger = LoggerFactory.getLogger(WindowsStartup.class);
    public static final String VSOI_KEY = "SOFTWARE\\Classes\\vsoi\\Shell\\Open\\Command";
    protected static final String CMD_NAME = "vsts.cmd";
    protected static final String WIN_DIR = "win";

    public static void startup() {
        try {
            String cmdPath = IdeaHelper.getResourcePath(WindowsStartup.class.getResource("/"), CMD_NAME, WIN_DIR);
            File cmdFile = new File(cmdPath);
            if (cmdFile.exists() && WindowsStartup.doesKeyNeedUpdated(cmdFile)) {
                File regeditFile = WindowsStartup.createRegeditFile(cmdFile);
                WindowsStartup.launchCreation(regeditFile.getPath());
                regeditFile.delete();
            }
        }
        catch (IOException e) {
            logger.warn("An IOException was encountered while creating/writing to the Regedit file: {}", (Object)e.getMessage());
        }
        catch (Win32Exception e) {
            logger.warn("A Win32Exception was encountered while trying to get IntelliJ's registry key: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.warn("An exception was encountered while trying to create vsoi registry key: {}", (Object)e.getMessage());
        }
    }

    protected static boolean doesKeyNeedUpdated(File newCmd) throws IOException {
        try {
            String existingKey = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)VSOI_KEY, (String)"");
            File existingCmd = new File(existingKey.replace("\"%1\"", "").trim());
            if (!existingCmd.exists()) {
                logger.debug("The registry key needs updated because the old key cmd file doesn't exist.");
                return true;
            }
            if (existingCmd.getPath().equalsIgnoreCase(newCmd.getPath()) || FileUtils.contentEquals((File)existingCmd, (File)newCmd)) {
                logger.debug("The registry key does not need updated because {}", (Object)(existingCmd.getPath().equalsIgnoreCase(newCmd.getPath()) ? "the file paths are the same" : "the contents of the files are the same."));
                return false;
            }
            logger.debug("The existing cmd file is {} old and the the cmd file is {} old", (Object)existingCmd.lastModified(), (Object)newCmd.lastModified());
            return existingCmd.lastModified() < newCmd.lastModified();
        }
        catch (Win32Exception e) {
            logger.debug("There was an issue reading the registry so updating the key to be safe.");
            return true;
        }
    }

    private static void launchCreation(String regeditFilePath) {
        try {
            String[] cmd = new String[]{"cmd", "/C", "reg.exe", "import", regeditFilePath};
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            Process process = processBuilder.start();
            process.waitFor();
        }
        catch (IOException e) {
            logger.warn("Running regedit encountered an IOException: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.warn("Waiting for the process to execute resulted in an error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File createRegeditFile(File newCmd) throws IOException {
        File script = File.createTempFile("CreateKeys", ".reg");
        FileWriter fileWriter = new FileWriter(script);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        try {
            bufferedWriter.write("Windows Registry Editor Version 5.00\r\n\r\n[-HKEY_CURRENT_USER\\SOFTWARE\\Classes\\vsoi]\r\n\r\n[HKEY_CURRENT_USER\\SOFTWARE\\Classes\\vsoi]\r\n\"URL Protocol\"=\"\"\r\n\r\n[HKEY_CURRENT_USER\\SOFTWARE\\Classes\\vsoi\\Shell\\Open\\Command]\r\n\"\"=\"" + newCmd.getPath().replace("\\", "\\\\") + " \\\"%1\\\" \"");
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        return script;
    }
}

