/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.statusBar;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.events.ServerEvent;
import com.microsoft.alm.plugin.events.ServerEventListener;
import com.microsoft.alm.plugin.events.ServerEventManager;
import com.microsoft.alm.plugin.idea.common.statusBar.BuildStatusModel;
import com.microsoft.alm.plugin.idea.common.statusBar.BuildWidget;
import com.microsoft.alm.plugin.idea.common.utils.EventContextHelper;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.operations.BuildStatusLookupOperation;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.plugin.operations.OperationFactory;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusBarManager {
    private static final Logger logger = LoggerFactory.getLogger(StatusBarManager.class);
    private static ServerEventListener serverEventListener;

    public static void setupStatusBar() {
        if (serverEventListener == null) {
            serverEventListener = new ServerEventListener(){

                public void serverChanged(ServerEvent event, final Map<String, Object> contextMap) {
                    if (event == ServerEvent.BUILDS_CHANGED) {
                        IdeaHelper.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (EventContextHelper.isProjectOpened(contextMap) || EventContextHelper.isRepositoryChanged(contextMap)) {
                                        StatusBarManager.updateStatusBar(EventContextHelper.getProject(contextMap), false);
                                    } else if (EventContextHelper.isProjectClosing(contextMap)) {
                                        StatusBarManager.removeWidgets(EventContextHelper.getProject(contextMap));
                                    } else {
                                        StatusBarManager.updateStatusBar();
                                    }
                                }
                                catch (Throwable t) {
                                    logger.warn("Unable to update the status bar.", t);
                                }
                            }
                        });
                    }
                }
            };
            ServerEventManager.getInstance().addListener(serverEventListener);
        }
    }

    private static void updateStatusBar() {
        Project[] openProjects;
        for (Project p : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            StatusBarManager.updateStatusBar(p, false);
        }
    }

    public static void updateStatusBar(Project project, boolean allowPrompt) {
        if (IdeaHelper.isRider() && !VcsHelper.isVstsRepo(project)) {
            StatusBarManager.removeWidgets(project);
        } else {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar != null) {
                StatusBarManager.updateWidgets(statusBar, project, allowPrompt);
            }
        }
    }

    private static void updateWidgets(final StatusBar statusBar, final Project project, boolean allowPrompt) {
        RepositoryContext repositoryContext;
        BuildWidget buildWidget = (BuildWidget)statusBar.getWidget(BuildWidget.getID());
        if (buildWidget == null) {
            buildWidget = new BuildWidget();
            statusBar.addWidget((StatusBarWidget)buildWidget, (Disposable)project);
        }
        if ((repositoryContext = VcsHelper.getRepositoryContext(project)) != null) {
            final BuildWidget widget = buildWidget;
            BuildStatusLookupOperation op = OperationFactory.createBuildStatusLookupOperation((RepositoryContext)repositoryContext, (boolean)allowPrompt);
            op.addListener(new Operation.Listener(){

                public void notifyLookupStarted() {
                }

                public void notifyLookupCompleted() {
                }

                public void notifyLookupResults(Operation.Results results) {
                    StatusBarManager.updateBuildWidget(project, statusBar, widget, (BuildStatusLookupOperation.BuildStatusResults)results);
                }
            });
            op.doWorkAsync(null);
        }
    }

    private static void updateBuildWidget(Project project, final StatusBar statusBar, BuildWidget widget, BuildStatusLookupOperation.BuildStatusResults results) {
        BuildStatusLookupOperation.BuildStatusResults r = results;
        BuildStatusModel model = BuildStatusModel.create(project, results);
        widget.update(model);
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                statusBar.updateWidget(BuildWidget.getID());
            }
        });
    }

    private static void removeWidgets(Project project) {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        if (statusBar != null && statusBar.getWidget(BuildWidget.getID()) != null) {
            statusBar.removeWidget(BuildWidget.getID());
        }
    }
}

