/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.checkout;

import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.AuthenticationProvider;
import com.microsoft.alm.plugin.authentication.TfsAuthenticationProvider;
import com.microsoft.alm.plugin.authentication.VsoAuthenticationProvider;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutModel;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutPageModelImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.LookupHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.operations.ServerContextLookupOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TfsCheckoutPageModel
extends CheckoutPageModelImpl {
    private static final Logger logger = LoggerFactory.getLogger(CheckoutPageModelImpl.class);
    private AuthenticationProvider authenticationProvider;
    private final ServerContextLookupOperation.ContextScope scope;

    public TfsCheckoutPageModel(CheckoutModel checkoutModel) {
        super(checkoutModel, checkoutModel.getRepositoryType() == RepositoryContext.Type.GIT ? ServerContextTableModel.TFS_GIT_REPO_COLUMNS : ServerContextTableModel.TFS_TFVC_REPO_COLUMNS);
        this.setConnected(false);
        this.setAuthenticating(false);
        this.scope = checkoutModel.getRepositoryType() == RepositoryContext.Type.GIT ? ServerContextLookupOperation.ContextScope.REPOSITORY : ServerContextLookupOperation.ContextScope.PROJECT;
        String serverName = this.getServerName();
        if (!UrlHelper.isTeamServicesUrl((String)serverName)) {
            this.authenticationProvider = TfsAuthenticationProvider.getInstance();
            if (this.authenticationProvider.isAuthenticated(serverName)) {
                logger.info("TFS auth info already found so reusing that for loading repos");
                AuthenticationInfo info = this.authenticationProvider.getAuthenticationInfo(serverName);
                this.setServerNameInternal(info.getServerUri());
                LookupHelper.loadTfsContexts(this, this, this.authenticationProvider, this.getRepositoryProvider(), this.scope);
            }
        } else {
            this.authenticationProvider = VsoAuthenticationProvider.getInstance();
            if (this.authenticationProvider.isAuthenticated(serverName)) {
                logger.info("VSTS auth info already found so reusing that for loading repos");
                this.setServerNameInternal(this.authenticationProvider.getAuthenticationInfo(serverName).getServerUri());
                LookupHelper.loadVsoContexts(this, this, this.authenticationProvider, this.getRepositoryProvider(), this.scope);
            }
        }
    }

    @Override
    protected AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationProvider.getAuthenticationInfo(this.getServerName());
    }

    @Override
    public void signOut() {
        super.signOut();
        this.authenticationProvider.clearAuthenticationDetails(this.getServerName());
    }

    @Override
    public void loadRepositories() {
        if (UrlHelper.isTeamServicesUrl((String)this.getServerName())) {
            this.authenticationProvider = VsoAuthenticationProvider.getInstance();
            LookupHelper.authenticateAndLoadVsoContexts(this, this, this.authenticationProvider, this.getRepositoryProvider(), this.scope);
        } else {
            this.authenticationProvider = TfsAuthenticationProvider.getInstance();
            LookupHelper.authenticateAndLoadTfsContexts(this, this, this.authenticationProvider, this.getRepositoryProvider(), this.scope);
        }
    }
}

