/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.ActionListenerContainer;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialog;
import com.microsoft.alm.plugin.idea.common.ui.common.FeedbackAction;
import com.microsoft.alm.plugin.idea.common.ui.common.FocusableTabPage;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListener;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListenerContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseDialogImpl
extends DialogWrapper
implements BaseDialog {
    private JTabbedPane tabPanel;
    private ActionListenerContainer listenerContainer = new ActionListenerContainer();
    private ValidationListenerContainer validationListenerContainer = new ValidationListenerContainer();
    private final Project project;
    private final boolean showFeedback;
    private final String feedbackContext;
    private final Map<String, Object> properties;

    public BaseDialogImpl(Project project, String title, String okButtonText, String feedbackContext) {
        this(project, title, okButtonText, feedbackContext, true, null);
    }

    public BaseDialogImpl(Project project, String title, String okButtonText, String feedbackContext, boolean showFeedback, Map<String, Object> properties) {
        super(project);
        this.showFeedback = showFeedback;
        this.feedbackContext = feedbackContext;
        this.project = project;
        this.properties = properties != null ? new HashMap<String, Object>(properties) : Collections.emptyMap();
        super.setTitle(title);
        super.setOKButtonText(okButtonText);
        super.init();
    }

    protected Project getProject() {
        return this.project;
    }

    protected Object getProperty(String name) {
        return this.properties.get(name);
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        if (this.showFeedback) {
            Action[] actions = new Action[]{new FeedbackAction(this.project, this.feedbackContext)};
            if (actions == null) {
                BaseDialogImpl.$$$reportNull$$$0(0);
            }
            return actions;
        }
        Action[] actionArray = super.createLeftSideActions();
        if (actionArray == null) {
            BaseDialogImpl.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        this.tabPanel = new JTabbedPane();
        this.tabPanel.setPreferredSize(new Dimension(JBUI.scale((int)500), JBUI.scale((int)600)));
        this.tabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BaseDialogImpl.this.doTabChangedAction();
            }
        });
        return this.tabPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return this.feedbackContext;
    }

    protected void doTabChangedAction() {
        this.listenerContainer.triggerEvent(this, "tabChanged");
    }

    protected void doOKAction() {
        this.listenerContainer.triggerEvent(this, "ok");
        super.doOKAction();
    }

    public void doCancelAction() {
        this.listenerContainer.triggerEvent(this, "cancel");
        super.doCancelAction();
    }

    protected ValidationInfo doValidate() {
        try {
            return this.validationListenerContainer.doValidate();
        }
        catch (Throwable t) {
            return new ValidationInfo(LocalizationServiceImpl.getInstance().getExceptionMessage(t));
        }
    }

    @Override
    public void addTabPage(String text, JComponent component) {
        if (this.tabPanel != null) {
            SwingHelper.setMargin(component, JBUI.scale((int)10));
            this.tabPanel.addTab(text, component);
        }
    }

    @Override
    public int getSelectedTabIndex() {
        if (this.tabPanel != null) {
            return this.tabPanel.getSelectedIndex();
        }
        return -1;
    }

    @Override
    public void setSelectedTabIndex(int index) {
        if (this.tabPanel != null) {
            this.tabPanel.setSelectedIndex(index);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.tabPanel != null) {
            int i = this.getSelectedTabIndex();
            Component tab = this.tabPanel.getComponentAt(i);
            if (tab instanceof FocusableTabPage) {
                return ((FocusableTabPage)((Object)tab)).getPreferredFocusedComponent();
            }
            return this.tabPanel;
        }
        return super.getPreferredFocusedComponent();
    }

    @Override
    public void setOkEnabled(boolean enabled) {
        super.setOKActionEnabled(enabled);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listenerContainer.add(listener);
    }

    @Override
    public void addValidationListener(ValidationListener listener) {
        this.validationListenerContainer.add(listener);
    }

    @Override
    public void displayError(String message) {
        this.setErrorText(message);
    }

    @Override
    public boolean showModalDialog() {
        return super.showAndGet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/microsoft/alm/plugin/idea/common/ui/common/BaseDialogImpl", "createLeftSideActions"));
    }
}

