/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.PlatformIcons;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.FeedbackDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class FeedbackAction
extends AbstractAction {
    public static final String CMD_SEND_SMILE = "sendSmile";
    public static final String CMD_SEND_FROWN = "sendFrown";
    private final Project project;
    private final String feedbackContextInfo;
    private static final String URL_PRIVACY_POLICY = "https://go.microsoft.com/fwlink/?LinkID=277167";

    public FeedbackAction(Project project, String feedbackContextInfo) {
        super(TfPluginBundle.message("Feedback.Dialog.Title", new Object[0]), PlatformIcons.COMBOBOX_ARROW_ICON);
        this.project = project;
        this.feedbackContextInfo = feedbackContextInfo;
    }

    public JMenu getSubMenu() {
        JMenu menu = new JMenu(TfPluginBundle.message("Feedback.Dialog.Title", new Object[0]));
        menu.add((JMenuItem)this.createMenuItem("Feedback.Dialog.OkButtonText.Smile", Icons.Smile, CMD_SEND_SMILE));
        menu.add((JMenuItem)this.createMenuItem("Feedback.Dialog.OkButtonText.Frown", Icons.Frown, CMD_SEND_FROWN));
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (e != null);
        if (e.getSource() instanceof Component) {
            Component buttonSource = (Component)e.getSource();
            JBPopupMenu popupMenu = new JBPopupMenu();
            popupMenu.add((JMenuItem)this.createMenuItem("Feedback.Dialog.OkButtonText.Smile", Icons.Smile, CMD_SEND_SMILE));
            popupMenu.add((JMenuItem)this.createMenuItem("Feedback.Dialog.OkButtonText.Frown", Icons.Frown, CMD_SEND_FROWN));
            popupMenu.show(buttonSource, 0, buttonSource.getHeight());
        }
    }

    public void sendFeedback(boolean smile) {
        FeedbackDialog dialog = new FeedbackDialog(this.project, smile);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("gotoPrivacy".equalsIgnoreCase(e.getActionCommand())) {
                    BrowserUtil.browse((String)FeedbackAction.URL_PRIVACY_POLICY);
                }
            }
        });
        if (dialog.showAndGet()) {
            VcsNotifier.getInstance((Project)this.project).notifySuccess(TfPluginBundle.message("Feedback.Dialog.Title", new Object[0]), TfPluginBundle.message("Feedback.Notification", new Object[0]));
        }
    }

    private JBMenuItem createMenuItem(String resourceKey, Icon icon, String actionCommand) {
        String text = TfPluginBundle.message(resourceKey, new Object[0]);
        JBMenuItem menuItem = new JBMenuItem(text, icon);
        menuItem.setActionCommand(actionCommand);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedbackAction.this.menuItemAction(e);
            }
        });
        return menuItem;
    }

    private void menuItemAction(ActionEvent e) {
        boolean smile = CMD_SEND_SMILE.equalsIgnoreCase(e.getActionCommand());
        this.sendFeedback(smile);
    }
}

