/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common;

import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;

public class ModelValidationInfo {
    public static final ModelValidationInfo NO_ERRORS = null;
    final boolean lookupResource;
    final String validationSource;
    final String validationMessageKey;
    final Object[] validationMessageArgs;

    public static ModelValidationInfo createWithMessage(String message) {
        return new ModelValidationInfo(false, null, message, new Object[0]);
    }

    public static ModelValidationInfo createWithResource(String resourceKey, Object ... arguments) {
        return new ModelValidationInfo(true, null, resourceKey, arguments);
    }

    public static ModelValidationInfo createWithResource(String source, String messageKey, Object ... arguments) {
        return new ModelValidationInfo(true, source, messageKey, arguments);
    }

    protected ModelValidationInfo(boolean lookupResource, String source, String messageKey, Object ... arguments) {
        this.lookupResource = lookupResource;
        this.validationSource = source;
        this.validationMessageKey = messageKey;
        this.validationMessageArgs = arguments == null || arguments.length == 0 ? null : arguments;
    }

    public String getValidationMessage() {
        if (this.lookupResource) {
            if (this.validationMessageArgs == null || this.validationMessageArgs.length == 0) {
                return TfPluginBundle.message(this.validationMessageKey, new Object[0]);
            }
            return TfPluginBundle.message(this.validationMessageKey, this.validationMessageArgs);
        }
        return this.validationMessageKey;
    }

    public String getValidationSource() {
        return this.validationSource;
    }

    public String getValidationMessageKey() {
        return this.validationMessageKey;
    }
}

