/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common.forms;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.LoginForm;
import com.microsoft.alm.plugin.idea.common.ui.controls.BusySpinnerPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.Hyperlink;
import com.microsoft.alm.plugin.idea.common.ui.controls.IconPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.WrappingLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.commons.lang.StringUtils;

public class TfsLoginForm
implements LoginForm {
    private JTextField serverUrl;
    private Hyperlink signInLink;
    private IconPanel vsIcon;
    private JPanel contentPanel;
    private JLabel exampleLabel;
    private WrappingLabel descriptionLabel;
    private JLabel headerLabel;
    private BusySpinnerPanel busySpinner;
    private JLabel loginProgressLabel;
    private boolean initialized = false;

    public TfsLoginForm() {
        this.$$$setupUI$$$();
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    @Override
    public String getServerName() {
        return StringUtils.trim((String)this.serverUrl.getText());
    }

    @Override
    public void setServerName(String serverName) {
        this.serverUrl.setText(serverName);
    }

    @Override
    public JComponent getServerNameComponent() {
        return this.serverUrl;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.signInLink.addActionListener(listener);
        this.serverUrl.registerKeyboardAction(listener, "signIn", KeyStroke.getKeyStroke(10, 0), 2);
    }

    @Override
    public void setAuthenticating(boolean inProgress) {
        if (inProgress) {
            this.busySpinner.start(true);
            this.loginProgressLabel.setText(TfPluginBundle.message("LoginForm.TFS.Authenticating", new Object[0]));
            this.signInLink.setEnabled(false);
        } else {
            this.busySpinner.stop(true);
            this.loginProgressLabel.setText("");
            this.signInLink.setEnabled(true);
        }
    }

    private void createUIComponents() {
        this.vsIcon = new IconPanel(Icons.VSLogo);
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.signInLink.setActionCommand("signIn");
            this.headerLabel.setFont((Font)JBUI.Fonts.label((float)20.0f));
            this.signInLink.setFont((Font)JBUI.Fonts.label((float)16.0f));
            this.exampleLabel.setFont((Font)JBUI.Fonts.label((float)9.0f));
            Dimension size = new Dimension(JBUI.scale((int)20), JBUI.scale((int)20));
            this.busySpinner.setPreferredSize(size);
            this.busySpinner.setMinimumSize(size);
            this.descriptionLabel.setMargin(new Insets(0, 0, JBUI.scale((int)15), 0));
            this.initialized = true;
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.serverUrl;
    }

    @VisibleForTesting
    BusySpinnerPanel getBusySpinner() {
        return this.busySpinner;
    }

    @VisibleForTesting
    void setServerUrl(String serverUrl) {
        this.serverUrl.setText(serverUrl);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        WrappingLabel wrappingLabel;
        BusySpinnerPanel busySpinnerPanel;
        JLabel jLabel;
        Hyperlink hyperlink;
        JLabel jLabel2;
        JTextField jTextField;
        JLabel jLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 2, 0, 2, 1, 6, null, null, null));
        this.headerLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("TfsLoginForm.Header"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 1, 1, 4, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("TfsLoginForm.ServerUrl"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.serverUrl = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 2, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.exampleLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("TfsLoginForm.ExampleUrl"));
        jPanel.add((Component)jLabel2, new GridConstraints(3, 2, 1, 3, 8, 0, 0, 0, null, null, null));
        this.signInLink = hyperlink = new Hyperlink();
        this.$$$loadLabelText$$$((JLabel)((Object)hyperlink), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("TfsLoginForm.Connect"));
        jPanel.add((Component)((Object)hyperlink), new GridConstraints(4, 2, 1, 3, 8, 0, 3, 3, null, null, null));
        IconPanel iconPanel = this.vsIcon;
        jPanel.add((Component)iconPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.loginProgressLabel = jLabel = new JLabel();
        jLabel.setText("Sample Text for Busy Spinner Message");
        jPanel.add((Component)jLabel, new GridConstraints(5, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.busySpinner = busySpinnerPanel = new BusySpinnerPanel();
        jPanel.add((Component)busySpinnerPanel, new GridConstraints(5, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.descriptionLabel = wrappingLabel = new WrappingLabel();
        wrappingLabel.setText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("TfsLoginForm.Description"));
        jPanel.add((Component)wrappingLabel, new GridConstraints(1, 1, 1, 4, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

