/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.controls;

import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.controls.Hyperlink;
import com.microsoft.alm.plugin.idea.common.ui.controls.IconPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UserAccountPanel
extends JPanel {
    public static final String CMD_SIGN_OUT = "signOut";
    private final Hyperlink hyperlink = new Hyperlink();
    private final JLabel accountLabel;
    private final JLabel serverLabel;
    private final IconPanel iconPanel;
    private boolean windowsAccount = true;

    public UserAccountPanel() {
        this.hyperlink.setText("");
        this.hyperlink.setActionCommand(CMD_SIGN_OUT);
        this.accountLabel = new JLabel();
        this.serverLabel = new JLabel();
        this.iconPanel = new IconPanel();
        this.setLayout(new GridBagLayout());
        SwingHelper.addToGridBag(this, this.iconPanel, 0, 0, 1, 2, 0, 4);
        SwingHelper.addToGridBag(this, this.serverLabel, 1, 0, 1, 1, 0, 4);
        SwingHelper.addToGridBag(this, this.accountLabel, 1, 1, 1, 1, 0, 4);
        SwingHelper.addToGridBag(this, (Component)((Object)this.hyperlink), 1, 2, 1, 1, 5, 4);
        this.setWindowsAccount(this.windowsAccount);
        this.setPreferredSize(new Dimension(64, 32));
    }

    public boolean isWindowsAccount() {
        return this.windowsAccount;
    }

    public void setWindowsAccount(boolean windowsAccount) {
        this.windowsAccount = windowsAccount;
        String signOutText = windowsAccount ? TfPluginBundle.message("UserAccountPanel.SwitchServer", new Object[0]) : TfPluginBundle.message("UserAccountPanel.SignOut", new Object[0]);
        this.hyperlink.setText(signOutText);
        this.iconPanel.setIcon(windowsAccount ? Icons.WindowsAccount : Icons.VsoAccount);
    }

    public void addActionListener(ActionListener listener) {
        this.hyperlink.addActionListener(listener);
    }

    public void setUserName(String name) {
        this.accountLabel.setText(name);
    }

    public void setServerName(String name) {
        this.serverLabel.setText(name);
    }
}

