/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.settings;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractController;
import com.microsoft.alm.plugin.idea.common.ui.settings.TeamServicesConfigurable;
import com.microsoft.alm.plugin.idea.common.ui.settings.TeamServicesSettingsForm;
import com.microsoft.alm.plugin.idea.common.ui.settings.TeamServicesSettingsModel;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.JComponent;

public class TeamServicesSettingsController
extends AbstractController {
    private final TeamServicesSettingsForm form;
    private final TeamServicesSettingsModel model;

    public TeamServicesSettingsController() {
        this(new TeamServicesSettingsForm(), new TeamServicesSettingsModel(IdeaHelper.getCurrentProject()));
    }

    @VisibleForTesting
    public TeamServicesSettingsController(TeamServicesSettingsForm form, TeamServicesSettingsModel model) {
        this.form = form;
        this.model = model;
        model.addObserver(this);
        form.addActionListener(this);
        this.update(null, null);
        model.loadSettings();
    }

    public JComponent getContentPane() {
        return this.form.getContentPane();
    }

    public boolean isModified() {
        return this.model.isModified();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null) {
            this.form.setContextTable(this.model.getTableModel(), this.model.getTableSelectionModel());
            this.form.setAuthType(this.model.getOriginalAuthType());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
        if (TeamServicesConfigurable.CMD_RESET_CHANGES.equals(e.getActionCommand())) {
            this.model.reset();
            this.form.setAuthType(this.model.getOriginalAuthType());
        } else if (TeamServicesConfigurable.CMD_APPLY_CHANGES.equals(e.getActionCommand())) {
            this.model.apply();
        } else if ("deletePassword".equals(e.getActionCommand())) {
            this.model.deletePasswords();
        } else if ("updatePasword".equals(e.getActionCommand())) {
            this.model.updatePasswords();
        } else if ("authChanged".equals(e.getActionCommand())) {
            this.model.setUpdatedAuthType(this.form.getSelectAuthType());
        }
    }

    @Override
    protected void updateModel() {
    }
}

