/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.settings;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.authentication.AuthTypes;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.TableFocusListener;
import com.microsoft.alm.plugin.idea.common.ui.common.TableModelSelectionConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableRowSorter;

public class TeamServicesSettingsForm {
    public static final String CMD_DELETE_PASSWORD = "deletePassword";
    public static final String CMD_UPDATE_PASSWORD = "updatePasword";
    public static final String CMD_AUTH_CHANGED = "authChanged";
    private JPanel mainPanel;
    private JButton updatePasswordButton;
    private JPanel passwordPanel;
    private JTable contextTable;
    private JScrollPane contextScrollPane;
    private JButton deletePasswordButton;
    private JRadioButton credsOption;
    private JRadioButton deviceFlowOption;
    private JPanel authTypePanel;

    public TeamServicesSettingsForm() {
        this.$$$setupUI$$$();
        SwingHelper.scaleTableRowHeight(this.contextTable);
        SwingHelper.fixTabKeys(this.contextTable);
        this.contextTable.addFocusListener(new TableFocusListener(this.contextTable));
        this.contextScrollPane.setMinimumSize(new Dimension(JBUI.scale((int)200), JBUI.scale((int)50)));
        this.updatePasswordButton.setActionCommand(CMD_UPDATE_PASSWORD);
        this.deletePasswordButton.setActionCommand(CMD_DELETE_PASSWORD);
        this.credsOption.setActionCommand(CMD_AUTH_CHANGED);
        this.deviceFlowOption.setActionCommand(CMD_AUTH_CHANGED);
    }

    public JComponent getContentPane() {
        return this.mainPanel;
    }

    public void setContextTable(ServerContextTableModel tableModel, ListSelectionModel selectionModel) {
        this.contextTable.setModel(tableModel);
        this.contextTable.setSelectionModel(selectionModel);
        TableRowSorter<ServerContextTableModel> sorter = new TableRowSorter<ServerContextTableModel>(tableModel);
        this.contextTable.setRowSorter(sorter);
        tableModel.setSelectionConverter(new TableModelSelectionConverter(){

            @Override
            public int convertRowIndexToModel(int viewRowIndex) {
                if (viewRowIndex >= 0) {
                    return TeamServicesSettingsForm.this.contextTable.convertRowIndexToModel(viewRowIndex);
                }
                return viewRowIndex;
            }
        });
    }

    public void setAuthType(AuthTypes authType) {
        if (AuthTypes.DEVICE_FLOW == authType) {
            this.credsOption.setSelected(false);
            this.deviceFlowOption.setSelected(true);
        } else {
            this.credsOption.setSelected(true);
            this.deviceFlowOption.setSelected(false);
        }
    }

    public AuthTypes getSelectAuthType() {
        if (this.deviceFlowOption.isSelected()) {
            return AuthTypes.DEVICE_FLOW;
        }
        return AuthTypes.CREDS;
    }

    public void addActionListener(ActionListener listener) {
        this.deletePasswordButton.addActionListener(listener);
        this.updatePasswordButton.addActionListener(listener);
        this.deviceFlowOption.addActionListener(listener);
        this.credsOption.addActionListener(listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JTable jTable;
        JScrollPane jScrollPane;
        JPanel jPanel2;
        JPanel jPanel3;
        this.mainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.passwordPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Config.Mgt.Title"), 0, 0, null, null));
        this.contextScrollPane = jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.contextTable = jTable = new JTable();
        jTable.setPreferredScrollableViewportSize(new Dimension(450, 150));
        jScrollPane.setViewportView(jTable);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.deletePasswordButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Config.Mgt.DeleteButton"));
        jPanel4.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.updatePasswordButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Config.Mgt.UpdateButton"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.authTypePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Auth.Method.Title"), 0, 0, null, null));
        this.credsOption = jRadioButton2 = new JRadioButton();
        ((Component)jRadioButton2).setEnabled(true);
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Auth.Method.Creds.Button"));
        jRadioButton2.setToolTipText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Auth.Method.Creds.ToolTip"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.deviceFlowOption = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Auth.Method.DeviceFlow.Button"));
        jRadioButton.setToolTipText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Auth.Method.DeviceFlow.ToolTip"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

