/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.workitem;

import com.intellij.icons.AllIcons;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.TableFocusListener;
import com.microsoft.alm.plugin.idea.common.ui.common.TableModelSelectionConverter;
import com.microsoft.alm.plugin.idea.common.ui.controls.BusySpinnerPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.FormattedTable;
import com.microsoft.alm.plugin.idea.common.ui.controls.HelpPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.HintTextFieldUI;
import com.microsoft.alm.plugin.idea.common.ui.controls.Hyperlink;
import com.microsoft.alm.plugin.idea.common.ui.workitem.WorkItemsTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;

public class SelectWorkItemsForm {
    private JLabel serverName;
    private JTextField filter;
    private JButton refreshButton;
    private FormattedTable workItemTable;
    private Hyperlink newWorkItemLink;
    private JPanel contentPanel;
    private BusySpinnerPanel busySpinner;
    private JScrollPane scrollPane;
    private HelpPanel helpPanel;
    private boolean initialized = false;
    private Timer timer;
    @NonNls
    public static final String CMD_FILTER_CHANGED = "filterChanged";
    @NonNls
    public static final String CMD_REFRESH = "refresh";
    @NonNls
    public static final String CMD_NEW_WORK_ITEM = "newWorkItem";
    @NonNls
    public static final String CMD_GOTO_VIEW_MY_WORK_ITEMS = "gotoViewMyWorkItems";

    public SelectWorkItemsForm() {
        this.$$$setupUI$$$();
        this.timer = new Timer(400, null);
        this.timer.setInitialDelay(400);
        this.timer.setActionCommand(CMD_FILTER_CHANGED);
        this.timer.setRepeats(false);
    }

    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.filter.setActionCommand(CMD_FILTER_CHANGED);
            this.refreshButton.setActionCommand(CMD_REFRESH);
            this.newWorkItemLink.setActionCommand(CMD_NEW_WORK_ITEM);
            SwingHelper.scaleTableRowHeight((JTable)((Object)this.workItemTable));
            SwingHelper.fixTabKeys((JComponent)((Object)this.workItemTable));
            this.workItemTable.addFocusListener(new TableFocusListener((JTable)((Object)this.workItemTable)));
            this.helpPanel.addPopupCommand(TfPluginBundle.message("WitSelectDialog.Help.ViewMyWorkItems", new Object[0]), CMD_GOTO_VIEW_MY_WORK_ITEMS);
            this.helpPanel.setVisible(false);
            this.filter.setUI(new HintTextFieldUI(TfPluginBundle.message("WitSelectDialog.FilterHintText", new Object[0])));
            int refreshButtonHeight = (int)this.refreshButton.getMinimumSize().getHeight();
            Dimension size = new Dimension(refreshButtonHeight, refreshButtonHeight);
            this.refreshButton.setMinimumSize(size);
            this.refreshButton.setPreferredSize(size);
            this.busySpinner.setMinimumSize(size);
            this.busySpinner.setPreferredSize(size);
            this.filter.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                private void onFilterChanged() {
                    if (SelectWorkItemsForm.this.timer.isRunning()) {
                        SelectWorkItemsForm.this.timer.restart();
                    } else {
                        SelectWorkItemsForm.this.timer.start();
                    }
                }
            });
            this.scrollPane.setMinimumSize(new Dimension(JBUI.scale((int)600), JBUI.scale((int)400)));
            this.initialized = true;
        }
    }

    public void addActionListener(ActionListener listener) {
        this.timer.addActionListener(listener);
        this.refreshButton.addActionListener(listener);
        this.newWorkItemLink.addActionListener(listener);
        this.helpPanel.addActionListener(listener);
    }

    public void setFilter(String filterString) {
        this.filter.setText(filterString);
    }

    public String getFilter() {
        return this.filter.getText();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.filter;
    }

    public void setWorkItemTable(WorkItemsTableModel tableModel, ListSelectionModel selectionModel) {
        this.workItemTable.setModel(tableModel);
        this.workItemTable.setSelectionModel(selectionModel);
        TableRowSorter<WorkItemsTableModel> sorter = new TableRowSorter<WorkItemsTableModel>(tableModel);
        this.workItemTable.setRowSorter(sorter);
        tableModel.setSelectionConverter(new TableModelSelectionConverter(){

            @Override
            public int convertRowIndexToModel(int viewRowIndex) {
                if (viewRowIndex >= 0) {
                    return SelectWorkItemsForm.this.workItemTable.convertRowIndexToModel(viewRowIndex);
                }
                return viewRowIndex;
            }
        });
    }

    public void setServerName(String name) {
        this.serverName.setText(name);
    }

    public void setLoading(boolean loading) {
        if (loading) {
            this.refreshButton.setVisible(false);
            this.busySpinner.start(true);
        } else {
            this.busySpinner.stop(true);
            this.refreshButton.setVisible(true);
        }
    }

    public void setShowHelpPanel(boolean show) {
        this.helpPanel.setVisible(show);
    }

    private void createUIComponents() {
        this.workItemTable = new FormattedTable(WorkItemsTableModel.Column.TITLE.toString());
        this.refreshButton = new JButton(AllIcons.Actions.Refresh);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HelpPanel helpPanel;
        BusySpinnerPanel busySpinnerPanel;
        Hyperlink hyperlink;
        JScrollPane jScrollPane;
        JTextField jTextField;
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Server: ");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.serverName = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 3, 8, 0, 0, 0, null, null, null));
        this.filter = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JButton jButton = this.refreshButton;
        jButton.setText("");
        jButton.setToolTipText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CheckoutDialog.RefreshButton.ToolTip"));
        jPanel.add((Component)jButton, new GridConstraints(1, 3, 1, 1, 0, 3, 3, 0, null, null, null));
        this.scrollPane = jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(3, 0, 1, 4, 0, 3, 7, 7, null, null, null));
        FormattedTable formattedTable = this.workItemTable;
        ((JTable)((Object)formattedTable)).setFillsViewportHeight(true);
        jScrollPane.setViewportView((Component)((Object)formattedTable));
        this.newWorkItemLink = hyperlink = new Hyperlink();
        ((JLabel)((Object)hyperlink)).setText("Create a new work item...");
        jPanel.add((Component)((Object)hyperlink), new GridConstraints(5, 0, 1, 4, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.busySpinner = busySpinnerPanel = new BusySpinnerPanel();
        jPanel.add((Component)busySpinnerPanel, new GridConstraints(1, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        this.helpPanel = helpPanel = new HelpPanel();
        helpPanel.setHelpText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WitSelectDialog.Help.HelpText"));
        helpPanel.setPopupText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WitSelectDialog.Help.Instructions"));
        jPanel.add((Component)helpPanel, new GridConstraints(4, 0, 1, 4, 4, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

