/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.workitem;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractModel;
import com.microsoft.alm.plugin.idea.common.ui.workitem.WorkItemHelper;
import com.microsoft.alm.plugin.idea.common.ui.workitem.WorkItemsTableModel;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.plugin.operations.WorkItemLookupOperation;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItem;
import java.net.URI;
import javax.swing.ListSelectionModel;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectWorkItemsModel
extends AbstractModel {
    private static final Logger logger = LoggerFactory.getLogger(SelectWorkItemsModel.class);
    public static final String PROP_LOADING = "loading";
    public static final String PROP_FILTER = "filter";
    public static final String PROP_SERVER_NAME = "serverName";
    private final WorkItemsTableModel tableModel;
    private final Project project;
    private final RepositoryContext repositoryContext;
    private boolean loading = false;
    private String filter;
    private ServerContext latestServerContext;
    private boolean maxItemsReached = false;

    public SelectWorkItemsModel(Project project, RepositoryContext repositoryContext) {
        ArgumentHelper.checkNotNull((Object)project, (String)"project");
        ArgumentHelper.checkNotNull((Object)repositoryContext, (String)"repositoryContext");
        this.project = project;
        this.repositoryContext = repositoryContext;
        this.tableModel = new WorkItemsTableModel(WorkItemsTableModel.DEFAULT_COLUMNS);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        if (this.loading != loading) {
            this.loading = loading;
            this.setChangedAndNotify(PROP_LOADING);
        }
    }

    public boolean isMaxItemsReached() {
        return this.maxItemsReached;
    }

    public String getServerName() {
        if (this.latestServerContext != null) {
            return this.latestServerContext.getServerUri().toString();
        }
        return "";
    }

    public void loadWorkItems() {
        this.setLoading(true);
        this.tableModel.clearRows();
        WorkItemLookupOperation operation = new WorkItemLookupOperation(this.repositoryContext);
        operation.addListener(new Operation.Listener(){

            public void notifyLookupStarted() {
                logger.info("WorkItemLookupOperation started.");
            }

            public void notifyLookupCompleted() {
                logger.info("WorkItemLookupOperation completed.");
                IdeaHelper.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SelectWorkItemsModel.this.setLoading(false);
                    }
                });
            }

            public void notifyLookupResults(Operation.Results results) {
                final WorkItemLookupOperation.WitResults wiResults = (WorkItemLookupOperation.WitResults)results;
                SelectWorkItemsModel.this.maxItemsReached = wiResults.maxItemsReached();
                if (!wiResults.isCancelled()) {
                    final ServerContext newContext = wiResults.hasError() && AuthHelper.isNotAuthorizedError((Throwable)wiResults.getError()) ? ServerContextManager.getInstance().updateAuthenticationInfo(SelectWorkItemsModel.this.repositoryContext.getUrl()) : null;
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (wiResults.hasError()) {
                                if (AuthHelper.isNotAuthorizedError((Throwable)wiResults.getError())) {
                                    if (newContext != null) {
                                        SelectWorkItemsModel.this.loadWorkItems();
                                    }
                                } else {
                                    IdeaHelper.showErrorDialog(SelectWorkItemsModel.this.project, wiResults.getError());
                                }
                            }
                            if (wiResults.getContext() != null) {
                                SelectWorkItemsModel.this.latestServerContext = wiResults.getContext();
                                SelectWorkItemsModel.this.setChangedAndNotify(SelectWorkItemsModel.PROP_SERVER_NAME);
                            }
                            SelectWorkItemsModel.this.tableModel.addWorkItems(wiResults.getWorkItems());
                        }
                    });
                }
            }
        });
        operation.doWorkAsync((Operation.Inputs)new WorkItemLookupOperation.WitInputs(WorkItemHelper.getAssignedToMeQuery(), WorkItemHelper.getDefaultFields()));
    }

    public void createWorkItem() {
        if (this.latestServerContext != null && this.latestServerContext.getTeamProjectURI() != null) {
            URI teamProjectURI = this.latestServerContext.getTeamProjectURI();
            if (teamProjectURI != null) {
                super.gotoLink(UrlHelper.getCreateWorkItemURI((URI)teamProjectURI).toString());
            } else {
                logger.warn("Can't goto 'create work item' link: Unable to get team project URI from server context.");
            }
        }
    }

    public void gotoMyWorkItems() {
        if (this.latestServerContext != null && this.latestServerContext.getTeamProjectURI() != null) {
            URI teamProjectURI = this.latestServerContext.getTeamProjectURI();
            if (teamProjectURI != null) {
                super.gotoLink(UrlHelper.getCreateWorkItemURI((URI)teamProjectURI).toString());
            } else {
                logger.warn("Can't goto 'create work item' link: Unable to get team project URI from server context.");
            }
        }
    }

    public WorkItemsTableModel getTableModel() {
        return this.tableModel;
    }

    public ListSelectionModel getTableSelectionModel() {
        return this.tableModel.getSelectionModel();
    }

    public void setFilter(String filter) {
        if (!StringUtils.equals((String)this.filter, (String)filter)) {
            this.filter = filter;
            this.setChangedAndNotify(PROP_FILTER);
            this.tableModel.setFilter(filter);
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public String getComment() {
        ListSelectionModel selectionModel = this.getTableSelectionModel();
        if (!selectionModel.isSelectionEmpty()) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (WorkItem item : this.tableModel.getSelectedWorkItems()) {
                sb.append(separator);
                sb.append(WorkItemHelper.getWorkItemCommitMessage(item));
                separator = "\n";
            }
            return sb.toString();
        }
        return "";
    }
}

