/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.workitem;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.ui.common.TableModelSelectionConverter;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.TabFormImpl;
import com.microsoft.alm.plugin.idea.common.ui.controls.FormattedTable;
import com.microsoft.alm.plugin.idea.common.ui.controls.WorkItemQueryDropDown;
import com.microsoft.alm.plugin.idea.common.ui.workitem.WorkItemsTableModel;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.plugin.operations.WorkItemLookupOperation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;

public class VcsWorkItemsForm
extends TabFormImpl<WorkItemsTableModel> {
    private final WorkItemQueryDropDown queryDropDown;
    private FormattedTable workItemsTable;
    private final boolean isGitRepo;
    public static final String CMD_CREATE_BRANCH = "createBranch";
    public static final String TOOLBAR_LOCATION = "Vcs.WorkItems";

    public VcsWorkItemsForm(@NotNull Project project) {
        if (project == null) {
            VcsWorkItemsForm.$$$reportNull$$$0(0);
        }
        super("VcsWorkItemsTab.Title", "VcsWorkItemsTab.Create.WorkItem", "VcsWorkItemsTab.Refresh.Tooltip", TOOLBAR_LOCATION);
        this.isGitRepo = VcsHelper.isGitVcs(project);
        this.queryDropDown = new WorkItemQueryDropDown(project);
        this.ensureInitialized();
    }

    @VisibleForTesting
    protected VcsWorkItemsForm(boolean isGitRepo, WorkItemQueryDropDown queryDropDown) {
        super("VcsWorkItemsTab.Title", "VcsWorkItemsTab.Create.WorkItem", "VcsWorkItemsTab.Refresh.Tooltip", TOOLBAR_LOCATION);
        this.isGitRepo = isGitRepo;
        this.queryDropDown = queryDropDown;
    }

    @Override
    protected void createCustomView() {
        this.workItemsTable = new FormattedTable(WorkItemsTableModel.Column.TITLE.toString());
        this.workItemsTable.customizeHeader();
        this.scrollPanel = new JBScrollPane((Component)((Object)this.workItemsTable));
    }

    @Override
    protected void addCustomTools(JPanel toolBar) {
        toolBar.add(Box.createRigidArea(new Dimension(JBUI.scale((int)14), 0)));
        toolBar.add(this.queryDropDown);
    }

    @Override
    public void setModelForView(WorkItemsTableModel tableModel) {
        this.workItemsTable.setModel(tableModel);
        this.workItemsTable.setSelectionModel(tableModel.getSelectionModel());
        this.workItemsTable.setAutoResizeMode(3);
        this.searchFilter.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.onFilterChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.onFilterChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.onFilterChanged();
            }

            private void onFilterChanged() {
                if (VcsWorkItemsForm.this.timer.isRunning()) {
                    VcsWorkItemsForm.this.timer.restart();
                } else {
                    VcsWorkItemsForm.this.timer.start();
                }
            }
        });
        TableRowSorter<WorkItemsTableModel> sorter = new TableRowSorter<WorkItemsTableModel>(tableModel);
        this.workItemsTable.setRowSorter(sorter);
        tableModel.setSelectionConverter(new TableModelSelectionConverter(){

            @Override
            public int convertRowIndexToModel(int viewRowIndex) {
                if (viewRowIndex >= 0) {
                    return VcsWorkItemsForm.this.workItemsTable.convertRowIndexToModel(viewRowIndex);
                }
                return viewRowIndex;
            }
        });
    }

    @Override
    public void addActionListener(ActionListener listener) {
        super.addActionListener(listener);
        this.addTableEventListeners(listener);
        this.queryDropDown.addActionListener(listener);
    }

    private void addTableEventListeners(final ActionListener listener) {
        this.workItemsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getClickCount() == 2) {
                    VcsWorkItemsForm.this.triggerEvent("openSelectedItem");
                } else if (mouseEvent.isPopupTrigger() || (mouseEvent.getModifiers() & 4) == 4) {
                    VcsWorkItemsForm.this.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), listener);
                }
            }
        });
        this.workItemsTable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    VcsWorkItemsForm.this.triggerEvent("openSelectedItem");
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    @Override
    protected List<JBMenuItem> getMenuItems(ActionListener listener) {
        ArrayList<JBMenuItem> menuItems = new ArrayList<JBMenuItem>();
        menuItems.add(this.createMenuItem("VcsTab.OpenInBrowser", null, "openSelectedItem", listener));
        if (this.isGitRepo) {
            menuItems.add(this.createMenuItem("VcsWorkItemsTab.Create.Branch", null, CMD_CREATE_BRANCH, listener));
        }
        return menuItems;
    }

    @Override
    public Operation.CredInputsImpl getOperationInputs() {
        return new WorkItemLookupOperation.WitInputs(this.queryDropDown.getSelectedResults());
    }

    @Override
    public void refresh(boolean isTeamServicesRepository) {
        this.queryDropDown.refreshDropDown(isTeamServicesRepository);
    }

    @VisibleForTesting
    FormattedTable getWorkItemsTable() {
        return this.workItemsTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/microsoft/alm/plugin/idea/common/ui/workitem/VcsWorkItemsForm", "<init>"));
    }
}

