/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.workitem;

import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItem;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemRelation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class WorkItemHelper {
    public static final String FIELD_ASSIGNED_TO = "System.AssignedTo";
    public static final String FIELD_ID = "System.Id";
    public static final String FIELD_STATE = "System.State";
    public static final String FIELD_TITLE = "System.Title";
    public static final String FIELD_WORK_ITEM_TYPE = "System.WorkItemType";
    public static final String BRANCH_ATTRIBUTE_NAME = "name";
    public static final String BRANCH_ATTRIBUTE_VALUE = "branch";

    public static String getAssignedToMeQuery() {
        return "select system.id, system.workitemtype, system.title, system.assignedto, system.state, system.changeddate from workitems where system.assignedto = @me and system.teamproject = @project and microsoft.vsts.common.closedby = '' order by system.changeddate desc, system.id desc";
    }

    public static List<String> getDefaultFields() {
        ArrayList<String> fields = new ArrayList<String>(4);
        fields.add(FIELD_ASSIGNED_TO);
        fields.add(FIELD_ID);
        fields.add(FIELD_STATE);
        fields.add(FIELD_TITLE);
        fields.add(FIELD_WORK_ITEM_TYPE);
        return fields;
    }

    public static String getFieldValue(@NotNull WorkItem item, @NotNull String fieldName) {
        HashMap fieldMap;
        if (item == null) {
            WorkItemHelper.$$$reportNull$$$0(0);
        }
        if (fieldName == null) {
            WorkItemHelper.$$$reportNull$$$0(1);
        }
        if ((fieldMap = item.getFields()) != null) {
            if (fieldMap.containsKey(fieldName)) {
                Object value = fieldMap.get(fieldName);
                if (value != null) {
                    return value.toString();
                }
            } else {
                for (Map.Entry entry : fieldMap.entrySet()) {
                    if (!fieldName.equalsIgnoreCase((String)entry.getKey()) || entry.getValue() == null) continue;
                    return entry.getValue().toString();
                }
            }
        }
        return "";
    }

    public static String getRelationUrl(@NotNull WorkItem item, @NotNull String attributeName, @NotNull String attributeValue) {
        List relationsList;
        if (item == null) {
            WorkItemHelper.$$$reportNull$$$0(2);
        }
        if (attributeName == null) {
            WorkItemHelper.$$$reportNull$$$0(3);
        }
        if (attributeValue == null) {
            WorkItemHelper.$$$reportNull$$$0(4);
        }
        if ((relationsList = item.getRelations()) != null) {
            for (WorkItemRelation relation : relationsList) {
                HashMap attributes = relation.getAttributes();
                if (attributes == null || !attributes.containsKey(attributeName) || !attributeValue.equalsIgnoreCase(attributes.get(attributeName).toString())) continue;
                return relation.getUrl();
            }
        }
        return "";
    }

    public static String getLocalizedFieldName(String wellKnownFieldName) {
        if (FIELD_ASSIGNED_TO.equalsIgnoreCase(wellKnownFieldName)) {
            return TfPluginBundle.message("WitField.AssignedTo", new Object[0]);
        }
        if (FIELD_ID.equalsIgnoreCase(wellKnownFieldName)) {
            return TfPluginBundle.message("WitField.ID", new Object[0]);
        }
        if (FIELD_STATE.equalsIgnoreCase(wellKnownFieldName)) {
            return TfPluginBundle.message("WitField.State", new Object[0]);
        }
        if (FIELD_TITLE.equalsIgnoreCase(wellKnownFieldName)) {
            return TfPluginBundle.message("WitField.Title", new Object[0]);
        }
        if (BRANCH_ATTRIBUTE_VALUE.equalsIgnoreCase(wellKnownFieldName)) {
            return TfPluginBundle.message("WitField.Branch", new Object[0]);
        }
        if (FIELD_WORK_ITEM_TYPE.equalsIgnoreCase(wellKnownFieldName)) {
            return TfPluginBundle.message("WitField.WorkItemType", new Object[0]);
        }
        return "";
    }

    public static String getWorkItemCommitMessage(WorkItem item) {
        String num = WorkItemHelper.getFieldValue(item, FIELD_ID);
        String type = WorkItemHelper.getFieldValue(item, FIELD_WORK_ITEM_TYPE);
        String title = WorkItemHelper.getFieldValue(item, FIELD_TITLE);
        return TfPluginBundle.message("WitSelectDialog.CommitMessageFormat", type, num, title);
    }

    public static String getBranchName(WorkItem item) {
        return UrlHelper.parseUriForBranch((String)WorkItemHelper.getRelationUrl(item, BRANCH_ATTRIBUTE_NAME, BRANCH_ATTRIBUTE_VALUE));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
        }
        objectArray2[1] = "com/microsoft/alm/plugin/idea/common/ui/workitem/WorkItemHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelationUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

