/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.starters;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.starters.StarterBase;
import com.microsoft.alm.plugin.idea.git.ui.simplecheckout.SimpleCheckoutController;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCheckoutStarter
implements StarterBase {
    private final Logger logger = LoggerFactory.getLogger(SimpleCheckoutStarter.class);
    public static final String SUB_COMMAND_NAME = "checkout";
    private static final String URL_ARGUMENT = "url";
    private static final String REF_ARGUMENT = "Ref";
    private static final String ENCODING_ARGUMENT = "EncFormat";
    private final String gitUrl;
    private final String ref;

    private SimpleCheckoutStarter(String gitUrl, String ref) {
        this.gitUrl = gitUrl;
        this.ref = ref;
    }

    public static SimpleCheckoutStarter createWithGitUrl(String gitUrl, String ref) throws RuntimeException {
        if (!UrlHelper.isGitRemoteUrl((String)gitUrl)) {
            throw new RuntimeException(TfPluginBundle.message("Starter.Errors.InvalidGitUrl", gitUrl));
        }
        return new SimpleCheckoutStarter(gitUrl, ref);
    }

    public static SimpleCheckoutStarter createWithCommandLineArgs(List<String> args) throws RuntimeException {
        if (args.size() < 1) {
            throw new RuntimeException(TfPluginBundle.message("Starter.Errors.SimpleCheckout.InvalidCommandLineArgs", new Object[0]));
        }
        return SimpleCheckoutStarter.createWithGitUrl(args.get(0), args.size() < 2 ? "" : args.get(1));
    }

    public static SimpleCheckoutStarter createWithUriAttributes(Map<String, String> args) throws RuntimeException, UnsupportedEncodingException {
        String url = args.get(URL_ARGUMENT);
        String ref = args.get(REF_ARGUMENT);
        String encoding = args.get(ENCODING_ARGUMENT);
        if (StringUtils.isEmpty((String)url)) {
            throw new RuntimeException(TfPluginBundle.message("Starter.Errors.SimpleCheckout.UriMissingGitUrl", new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)encoding)) {
            url = URLDecoder.decode(url, encoding);
        }
        ref = StringUtils.isNotEmpty((String)ref) ? URLDecoder.decode(ref, encoding) : "";
        return SimpleCheckoutStarter.createWithGitUrl(url, ref);
    }

    @Override
    public void processCommand() {
        Project project = DefaultProjectFactory.getInstance().getDefaultProject();
        CheckoutProvider.Listener listener = ProjectLevelVcsManager.getInstance((Project)project).getCompositeCheckoutListener();
        try {
            this.launchApplicationWindow();
            SimpleCheckoutController controller = new SimpleCheckoutController(project, listener, this.gitUrl, this.ref);
            controller.showModalDialog();
        }
        catch (Throwable t) {
            this.logger.warn("VSTS commandline checkout failed due to an unexpected error", t);
            VcsNotifier.getInstance((Project)project).notifyError(TfPluginBundle.message("CheckoutDialog.Title", new Object[0]), TfPluginBundle.message("Checkout.Errors.Unexpected", t.getMessage()));
        }
    }

    private void launchApplicationWindow() {
        SystemDock.updateMenu();
        WindowManagerImpl windowManager = (WindowManagerImpl)WindowManager.getInstance();
        IdeEventQueue.getInstance().setWindowManager((WindowManagerEx)windowManager);
        windowManager.showFrame();
    }

    protected String getGitUrl() {
        return this.gitUrl;
    }
}

