/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.utils.DateHelper;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.PRTreeNode;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.PRTreeNodeForm;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPullRequest;
import com.microsoft.alm.sourcecontrol.webapi.model.IdentityRefWithVote;
import com.microsoft.alm.sourcecontrol.webapi.model.PullRequestAsyncStatus;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class PRTreeCellRenderer
extends DefaultTreeCellRenderer {
    public static final String GIT_REFS_HEADS = "refs/heads/";
    private static final short REVIEWER_VOTE_NO_RESPONSE = 0;
    private static final short REVIEWER_VOTE_APPROVED_WITH_SUGGESTIONS = 5;
    private static final short REVIEWER_VOTE_APPROVED = 10;
    private static final short REVIEWER_VOTE_WAITING_FOR_AUTHOR = -5;
    private static final short REVIEWER_VOTE_REJECTED = -10;
    private PRTreeNodeForm prViewForm;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.setIcon(null);
        if (value instanceof PRTreeNode && ((PRTreeNode)value).getGitPullRequest() != null) {
            GitPullRequest pullRequest = ((PRTreeNode)value).getGitPullRequest();
            this.prViewForm = new PRTreeNodeForm(selected, hasFocus);
            this.prViewForm.setSummary(TfPluginBundle.message("VcsPullRequestsTab.PR.Summary", pullRequest.getCreatedBy().getDisplayName(), String.valueOf(pullRequest.getPullRequestId()), DateHelper.getFriendlyDateTimeString(pullRequest.getCreationDate()), pullRequest.getSourceRefName().replace(GIT_REFS_HEADS, ""), pullRequest.getTargetRefName().replace(GIT_REFS_HEADS, "")));
            this.setStatus(this.prViewForm, pullRequest);
            JComponent component = this.prViewForm.getPanel();
            return component;
        }
        if (value instanceof PRTreeNode && ((PRTreeNode)value).getGitPullRequest() == null) {
            PRTreeNode rootNode = (PRTreeNode)value;
            SimpleColoredComponent component = new SimpleColoredComponent();
            SimpleTextAttributes regularTextAttributes = selected && hasFocus ? new SimpleTextAttributes(1, (Color)JBColor.WHITE) : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            component.append(rootNode.toString(), regularTextAttributes);
            component.append(" ");
            SimpleTextAttributes italicTextAttributes = selected && hasFocus ? new SimpleTextAttributes(2, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES;
            component.append(TfPluginBundle.message("VcsPullRequestsTab.View.Details.Count", rootNode.getChildCount()), italicTextAttributes);
            return component;
        }
        return this;
    }

    private void setStatus(PRTreeNodeForm prView, GitPullRequest pullRequest) {
        PullRequestAsyncStatus mergeStatus = pullRequest.getMergeStatus();
        if (mergeStatus == PullRequestAsyncStatus.CONFLICTS || mergeStatus == PullRequestAsyncStatus.FAILURE || mergeStatus == PullRequestAsyncStatus.REJECTED_BY_POLICY) {
            prView.setStatus(pullRequest.getTitle(), TfPluginBundle.message("VcsPullRequestsTab.Merge.Failed", new Object[0]), Icons.PR_STATUS_FAILED);
            return;
        }
        short lowestVote = 0;
        short highestVote = 0;
        if (pullRequest.getReviewers() != null && pullRequest.getReviewers().length > 0) {
            for (IdentityRefWithVote reviewer : pullRequest.getReviewers()) {
                short vote = reviewer.getVote();
                if (vote < lowestVote) {
                    lowestVote = vote;
                }
                if (vote <= highestVote) continue;
                highestVote = vote;
            }
        }
        short finalVote = 0;
        if (lowestVote < 0) {
            finalVote = lowestVote;
        } else if (highestVote > 0) {
            finalVote = highestVote;
        }
        String voteString = TfPluginBundle.message("VcsPullRequestsTab.Reviewer.NoResponse", new Object[0]);
        Icon voteIcon = Icons.PR_STATUS_NO_RESPONSE;
        if (finalVote == 5) {
            voteString = TfPluginBundle.message("VcsPullRequestsTab.Reviewer.Approved.Suggestions", new Object[0]);
            voteIcon = Icons.PR_STATUS_SUCCEEDED;
        }
        if (finalVote == 10) {
            voteString = TfPluginBundle.message("VcsPullRequestsTab.Reviewer.Approved", new Object[0]);
            voteIcon = Icons.PR_STATUS_SUCCEEDED;
        }
        if (finalVote == -5) {
            voteString = TfPluginBundle.message("VcsPullRequestsTab.Reviewer.Waiting", new Object[0]);
            voteIcon = Icons.PR_STATUS_WAITING;
        }
        if (finalVote == -10) {
            voteString = TfPluginBundle.message("VcsPullRequestsTab.Reviewer.Rejected", new Object[0]);
            voteIcon = Icons.PR_STATUS_FAILED;
        }
        prView.setStatus(pullRequest.getTitle(), voteString, voteIcon);
    }
}

