/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.FilteredModel;
import com.microsoft.alm.plugin.idea.common.utils.DateHelper;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.PRTreeNode;
import com.microsoft.alm.plugin.operations.PullRequestLookupOperation;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPullRequest;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.commons.lang.StringUtils;

public class PullRequestsTreeModel
extends DefaultTreeModel
implements FilteredModel {
    private final PRTreeNode root = new PRTreeNode(TfPluginBundle.message("VcsPullRequestsTab.Title", new Object[0]));
    private final PRTreeNode requestedByMeRoot;
    private final PRTreeNode assignedToMeRoot;
    private TreeSelectionModel selectionModel;
    private final List<GitPullRequest> allRequestedByMePullRequests;
    private final List<GitPullRequest> allAssignedToMePullRequests;
    private String filter;

    public PullRequestsTreeModel() {
        super(null);
        this.setRoot(this.root);
        this.requestedByMeRoot = new PRTreeNode(TfPluginBundle.message("VcsPullRequestsTab.RequestedByMe", new Object[0]));
        this.root.insert(this.requestedByMeRoot, 0);
        this.assignedToMeRoot = new PRTreeNode(TfPluginBundle.message("VcsPullRequestsTab.AssignedToMe", new Object[0]));
        this.root.insert(this.assignedToMeRoot, 1);
        this.allRequestedByMePullRequests = new ArrayList<GitPullRequest>();
        this.allAssignedToMePullRequests = new ArrayList<GitPullRequest>();
        this.selectionModel = new DefaultTreeSelectionModel();
        this.selectionModel.setSelectionMode(1);
    }

    public PRTreeNode getRequestedByMeRoot() {
        return this.requestedByMeRoot;
    }

    public PRTreeNode getAssignedToMeRoot() {
        return this.assignedToMeRoot;
    }

    public void appendPullRequests(List<GitPullRequest> pullRequests, PullRequestLookupOperation.PullRequestScope scope) {
        PRTreeNode rootNode;
        if (scope == PullRequestLookupOperation.PullRequestScope.REQUESTED_BY_ME) {
            rootNode = this.requestedByMeRoot;
            this.allRequestedByMePullRequests.addAll(pullRequests);
        } else {
            rootNode = this.assignedToMeRoot;
            this.allAssignedToMePullRequests.addAll(pullRequests);
        }
        if (this.hasFilter()) {
            this.applyFilter();
        } else {
            for (GitPullRequest pullRequest : pullRequests) {
                rootNode.add(new PRTreeNode(pullRequest));
            }
            this.reload(rootNode);
        }
    }

    public void clearPullRequests() {
        this.requestedByMeRoot.removeAllChildren();
        this.allRequestedByMePullRequests.clear();
        this.reload(this.requestedByMeRoot);
        this.assignedToMeRoot.removeAllChildren();
        this.allAssignedToMePullRequests.clear();
        this.reload(this.assignedToMeRoot);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public GitPullRequest getSelectedPullRequest() {
        TreePath treeModel = this.selectionModel.getLeadSelectionPath();
        return treeModel == null ? null : ((PRTreeNode)treeModel.getLastPathComponent()).getGitPullRequest();
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
        this.applyFilter();
    }

    private void applyFilter() {
        boolean hasFilter = this.hasFilter();
        this.assignedToMeRoot.removeAllChildren();
        this.requestedByMeRoot.removeAllChildren();
        for (GitPullRequest pr : this.allRequestedByMePullRequests) {
            if (hasFilter && !this.nodeContainsFilter(pr)) continue;
            this.requestedByMeRoot.add(new PRTreeNode(pr));
        }
        for (GitPullRequest pr : this.allAssignedToMePullRequests) {
            if (hasFilter && !this.nodeContainsFilter(pr)) continue;
            this.assignedToMeRoot.add(new PRTreeNode(pr));
        }
        this.reload(this.requestedByMeRoot);
        this.reload(this.assignedToMeRoot);
    }

    public boolean hasFilter() {
        return StringUtils.isNotEmpty((String)this.filter);
    }

    private boolean nodeContainsFilter(GitPullRequest pr) {
        if (pr == null) {
            return false;
        }
        return StringUtils.containsIgnoreCase((String)pr.getTitle(), (String)this.filter) || StringUtils.containsIgnoreCase((String)pr.getCreatedBy().getDisplayName(), (String)this.filter) || StringUtils.containsIgnoreCase((String)String.valueOf(pr.getPullRequestId()), (String)this.filter) || StringUtils.containsIgnoreCase((String)pr.getSourceRefName().replace("refs/heads/", ""), (String)this.filter) || StringUtils.containsIgnoreCase((String)pr.getTargetRefName().replace("refs/heads/", ""), (String)this.filter) || StringUtils.containsIgnoreCase((String)pr.getMergeStatus().toString(), (String)this.filter) || StringUtils.containsIgnoreCase((String)DateHelper.getFriendlyDateTimeString(pr.getCreationDate()), (String)this.filter);
    }
}

