/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.simplecheckout;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListener;
import com.microsoft.alm.plugin.idea.git.ui.simplecheckout.SimpleCheckoutDialog;
import com.microsoft.alm.plugin.idea.git.ui.simplecheckout.SimpleCheckoutModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;

public class SimpleCheckoutController
implements Observer,
ActionListener {
    private final SimpleCheckoutDialog dialog;
    private final SimpleCheckoutModel model;

    public SimpleCheckoutController(Project project, CheckoutProvider.Listener listener, String gitUrl, String ref) {
        this(new SimpleCheckoutDialog(project, TfPluginBundle.message("CheckoutDialog.Title", new Object[0]), TfPluginBundle.message("CheckoutDialog.CloneButton", new Object[0]), "CheckoutDialog.Title"), new SimpleCheckoutModel(project, listener, gitUrl, ref));
    }

    public SimpleCheckoutController(SimpleCheckoutDialog dialog, SimpleCheckoutModel model) {
        this.dialog = dialog;
        this.dialog.addActionListener(this);
        this.model = model;
        this.model.addObserver(this);
        this.setupDialog();
        this.update(null, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
        if ("ok".equals(e.getActionCommand())) {
            this.model.cloneRepo();
        }
    }

    public boolean showModalDialog() {
        return this.dialog.showModalDialog();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null || arg.equals("directoryName")) {
            this.dialog.setDirectoryName(this.model.getDirectoryName());
        }
        if (arg == null || arg.equals("parentDirectory")) {
            this.dialog.setParentDirectory(this.model.getParentDirectory());
        }
    }

    private void setupDialog() {
        this.dialog.setRepoUrl(this.model.getRepoUrl());
        this.dialog.addValidationListener(new ValidationListener(){

            @Override
            public ValidationInfo doValidate() {
                return SimpleCheckoutController.this.validate();
            }
        });
    }

    protected ValidationInfo validate() {
        this.updateModel();
        ModelValidationInfo validationInfo = this.model.validate();
        if (validationInfo != ModelValidationInfo.NO_ERRORS) {
            return new ValidationInfo(validationInfo.getValidationMessage(), this.dialog.getComponent(validationInfo.getValidationSource()));
        }
        return null;
    }

    protected void updateModel() {
        this.model.setParentDirectory(this.dialog.getParentDirectory());
        this.model.setDirectoryName(this.dialog.getDirectoryName());
    }
}

