/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.simplecheckout;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractModel;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import git4idea.GitRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBrancher;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCheckoutModel
extends AbstractModel {
    private final Logger logger = LoggerFactory.getLogger(SimpleCheckoutModel.class);
    public static final String DEFAULT_SOURCE_PATH = System.getProperty("user.home");
    public static final String PROP_DIRECTORY_NAME = "directoryName";
    public static final String PROP_PARENT_DIR = "parentDirectory";
    public static final String COMMANDLINE_CLONE_ACTION = "commandline-clone";
    public static final Pattern GIT_URL_PATTERN = Pattern.compile("/_git/(.*)");
    private static final String MASTER_BRANCH = "master";
    private final Project project;
    private final CheckoutProvider.Listener listener;
    private final String gitUrl;
    private final String ref;
    private String parentDirectory;
    private String directoryName;

    protected SimpleCheckoutModel(Project project, CheckoutProvider.Listener listener, String gitUrl, String ref) {
        Matcher matcher;
        this.project = project;
        this.listener = listener;
        this.gitUrl = gitUrl;
        this.ref = ref;
        this.parentDirectory = PluginServiceProvider.getInstance().getPropertyService().getProperty("repoRoot");
        if (StringUtils.isEmpty((String)this.parentDirectory)) {
            this.parentDirectory = DEFAULT_SOURCE_PATH;
        }
        this.directoryName = (matcher = GIT_URL_PATTERN.matcher(gitUrl)).find() && matcher.groupCount() == 1 ? matcher.group(1) : "";
    }

    public Project getProject() {
        return this.project;
    }

    public String getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        if (!StringUtils.equals((String)this.parentDirectory, (String)parentDirectory)) {
            this.parentDirectory = parentDirectory;
            this.setChangedAndNotify(PROP_PARENT_DIR);
        }
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        if (!StringUtils.equals((String)this.directoryName, (String)directoryName)) {
            this.directoryName = directoryName;
            this.setChangedAndNotify(PROP_DIRECTORY_NAME);
        }
    }

    public String getRepoUrl() {
        return this.gitUrl;
    }

    public ModelValidationInfo validate() {
        VirtualFile destinationParent;
        String parentDirectory = this.getParentDirectory();
        if (parentDirectory == null || parentDirectory.isEmpty()) {
            return ModelValidationInfo.createWithResource(PROP_PARENT_DIR, "CheckoutDialog.Errors.ParentDirEmpty", new Object[0]);
        }
        File parentDirectoryOnDisk = new File(parentDirectory);
        if (!parentDirectoryOnDisk.exists()) {
            return ModelValidationInfo.createWithResource(PROP_PARENT_DIR, "CheckoutDialog.Errors.ParentDirNotFound", new Object[0]);
        }
        if (ApplicationManager.getApplication() != null && (destinationParent = LocalFileSystem.getInstance().findFileByPath(parentDirectory)) == null) {
            return ModelValidationInfo.createWithResource(PROP_PARENT_DIR, "CheckoutDialog.Errors.ParentDirNotFound", new Object[0]);
        }
        String directoryName = this.getDirectoryName();
        if (directoryName == null || directoryName.isEmpty()) {
            return ModelValidationInfo.createWithResource(PROP_DIRECTORY_NAME, "CheckoutDialog.Errors.DirNameEmpty", new Object[0]);
        }
        File destDirectoryOnDisk = new File(parentDirectory, directoryName);
        if (destDirectoryOnDisk.exists() && destDirectoryOnDisk.isDirectory()) {
            return ModelValidationInfo.createWithResource(PROP_DIRECTORY_NAME, "CheckoutDialog.Errors.DestinationExists", directoryName);
        }
        if (destDirectoryOnDisk.getParentFile() == null || !destDirectoryOnDisk.getParentFile().exists()) {
            return ModelValidationInfo.createWithResource(PROP_DIRECTORY_NAME, "CheckoutDialog.Errors.DirNameInvalid", directoryName, destDirectoryOnDisk.getParent());
        }
        return ModelValidationInfo.NO_ERRORS;
    }

    public void cloneRepo() {
        ModelValidationInfo validationInfo = this.validate();
        if (validationInfo == null) {
            Task.Backgroundable createCloneTask = new Task.Backgroundable(this.project, TfPluginBundle.message("CheckoutDialog.Title", new Object[0]), true, PerformInBackgroundOption.DEAF){
                final AtomicBoolean cloneResult;
                {
                    this.cloneResult = new AtomicBoolean();
                }

                public void run(@NotNull ProgressIndicator progressIndicator) {
                    if (progressIndicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    progressIndicator.setText(TfPluginBundle.message("CheckoutDialog.Title", new Object[0]));
                    ServerContext context = ServerContextManager.getInstance().getUpdatedContext(SimpleCheckoutModel.this.gitUrl, true);
                    if (context == null) {
                        SimpleCheckoutModel.this.logger.warn("No context could be found");
                        VcsNotifier.getInstance((Project)SimpleCheckoutModel.this.project).notifyError(TfPluginBundle.message("CheckoutDialog.Errors.AuthenticationFailed.Title", new Object[0]), TfPluginBundle.message("Errors.AuthNotSuccessful", SimpleCheckoutModel.this.gitUrl));
                        return;
                    }
                    String gitRepositoryStr = context.getUsableGitUrl();
                    Git git = (Git)ServiceManager.getService(Git.class);
                    SimpleCheckoutModel.this.logger.info("Cloning repo " + gitRepositoryStr);
                    this.cloneResult.set(GitCheckoutProvider.doClone((Project)SimpleCheckoutModel.this.project, (Git)git, (String)SimpleCheckoutModel.this.getDirectoryName(), (String)SimpleCheckoutModel.this.getParentDirectory(), (String)gitRepositoryStr));
                }

                public void onSuccess() {
                    SimpleCheckoutModel.this.logger.info("Simple clone was a success");
                    if (this.cloneResult.get()) {
                        final VirtualFile destinationParent = LocalFileSystem.getInstance().findFileByIoFile(new File(SimpleCheckoutModel.this.getParentDirectory()));
                        File projectDirectory = new File(SimpleCheckoutModel.this.parentDirectory, SimpleCheckoutModel.this.directoryName);
                        DvcsUtil.addMappingIfSubRoot((Project)SimpleCheckoutModel.this.project, (String)FileUtil.join((String[])new String[]{SimpleCheckoutModel.this.parentDirectory, SimpleCheckoutModel.this.directoryName}), (String)"Git");
                        destinationParent.refresh(true, true, new Runnable(){

                            @Override
                            public void run() {
                                if (SimpleCheckoutModel.this.project.isOpen() && !SimpleCheckoutModel.this.project.isDisposed() && !SimpleCheckoutModel.this.project.isDefault()) {
                                    VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)SimpleCheckoutModel.this.project);
                                    mgr.fileDirty(destinationParent);
                                }
                            }
                        });
                        SimpleCheckoutModel.this.listener.directoryCheckedOut(projectDirectory, GitVcs.getKey());
                        SimpleCheckoutModel.this.listener.checkoutCompleted();
                        Project currentProject = IdeaHelper.getCurrentProject();
                        if (StringUtils.isNotEmpty((String)SimpleCheckoutModel.this.ref) && !StringUtils.equals((String)SimpleCheckoutModel.this.ref, (String)SimpleCheckoutModel.MASTER_BRANCH) && currentProject != null) {
                            SimpleCheckoutModel.this.logger.info("Non-master branch detected to checkout");
                            this.checkoutBranch(SimpleCheckoutModel.this.ref, currentProject, projectDirectory);
                        }
                    }
                }

                private void checkoutBranch(final String ref, final Project lastOpenedProject, final File projectDirectory) {
                    final ProjectLevelVcsManagerImpl manager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)lastOpenedProject);
                    manager.addInitializationRequest(VcsInitObject.MAPPINGS, new Runnable(){

                        @Override
                        public void run() {
                            manager.setDirectoryMapping(projectDirectory.getPath(), "Git");
                            manager.fireDirectoryMappingsChanged();
                        }
                    });
                    manager.addInitializationRequest(VcsInitObject.AFTER_COMMON, (Runnable)new DumbAwareRunnable(){

                        public void run() {
                            GitRepositoryManager gitRepositoryManager = (GitRepositoryManager)ServiceManager.getService((Project)lastOpenedProject, GitRepositoryManager.class);
                            ArgumentHelper.checkNotNull((Object)gitRepositoryManager, (String)"GitRepositoryManager");
                            ArgumentHelper.checkNotNullOrEmpty((List)gitRepositoryManager.getRepositories(), (String)"gitRepositoryManager.getRepositories()");
                            final GitRepository gitRepository = (GitRepository)gitRepositoryManager.getRepositories().get(0);
                            ArgumentHelper.checkNotNull((Object)gitRepository, (String)"GitRepository");
                            String fullRefName = "";
                            for (GitRemoteBranch remoteBranch : gitRepository.getInfo().getRemoteBranches()) {
                                String remoteBranchName = remoteBranch.getName().replaceFirst(remoteBranch.getRemote().getName() + "/", "");
                                if (!ref.equals(remoteBranchName)) continue;
                                fullRefName = remoteBranch.getName();
                            }
                            if (!StringUtils.isNotEmpty((String)fullRefName)) {
                                throw new IllegalArgumentException(String.format("Ref %s was not found remotely so could not be checked out.", fullRefName));
                            }
                            final String remoteRef = fullRefName;
                            IdeaHelper.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    SimpleCheckoutModel.this.logger.info("Checking out branch " + remoteRef);
                                    GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)lastOpenedProject, GitBrancher.class);
                                    brancher.checkoutNewBranchStartingFrom(ref, remoteRef, Collections.singletonList(gitRepository), null);
                                }
                            });
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/microsoft/alm/plugin/idea/git/ui/simplecheckout/SimpleCheckoutModel$1", "run"));
                }
            };
            createCloneTask.queue();
        }
    }
}

