/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.actions.OpenFileInBrowserAction;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.actions.SingleItemAction;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotateAction
extends SingleItemAction {
    private static final Logger logger = LoggerFactory.getLogger(OpenFileInBrowserAction.class);

    protected AnnotateAction() {
        super(TfPluginBundle.message("Actions.Annotate.Title", new Object[0]), TfPluginBundle.message("Actions.Annotate.Message", new Object[0]));
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        VirtualFile file;
        if (e == null) {
            AnnotateAction.$$$reportNull$$$0(0);
        }
        if ((file = VcsUtil.getOneVirtualFile((AnActionEvent)e)) == null || file.isDirectory()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        super.update(e);
    }

    @Override
    protected void execute(@NotNull SingleItemAction.SingleItemActionContext actionContext) {
        ServerContext context;
        if (actionContext == null) {
            AnnotateAction.$$$reportNull$$$0(1);
        }
        if ((context = actionContext.getServerContext()) != null && context.getTeamProjectReference() != null && actionContext.getItem() != null) {
            URI urlToBrowseTo = UrlHelper.getTfvcAnnotateURI((String)context.getUri().toString(), (String)context.getTeamProjectReference().getName(), (String)actionContext.getItem().getServerItem());
            logger.info("Browsing to url " + urlToBrowseTo.getPath());
            BrowserUtil.browse((URI)urlToBrowseTo);
        } else {
            String issue = context == null ? "context is null" : (context.getTeamProjectReference() == null ? "team project is null" : "getItem is null");
            logger.warn("Couldn't create annotate url: " + issue);
            Messages.showErrorDialog((Project)actionContext.getProject(), (String)TfPluginBundle.message("Actions.Annotate.Error.Msg", new Object[0]), (String)TfPluginBundle.message("Actions.Annotate.Error.Title", new Object[0]));
        }
    }

    @Override
    protected String getProgressMessage() {
        return TfPluginBundle.message("Actions.Annotate.Status", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
        }
        objectArray2[1] = "com/microsoft/alm/plugin/idea/tfvc/actions/AnnotateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

