/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.actions;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.MergeResults;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.actions.SingleItemAction;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.VersionControlPath;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.conflicts.ConflictsEnvironment;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.conflicts.ResolveConflictHelper;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import com.microsoft.alm.plugin.idea.tfvc.ui.MergeBranchDialog;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MergeBranchAction
extends SingleItemAction
implements DumbAware {
    protected MergeBranchAction() {
        super(TfPluginBundle.message("Actions.Tfvc.MergeBranch.Title", new Object[0]), TfPluginBundle.message("Actions.Tfvc.MergeBranch.Message", new Object[0]));
    }

    @Override
    protected void execute(final @NotNull SingleItemAction.SingleItemActionContext actionContext) throws TfsException {
        if (actionContext == null) {
            MergeBranchAction.$$$reportNull$$$0(0);
        }
        logger.info("executing...");
        String title = TfPluginBundle.message("Actions.Tfvc.MergeBranch.Title", new Object[0]);
        final ServerContext serverContext = actionContext.getServerContext();
        final Project project = actionContext.getProject();
        String sourceDialogInput = actionContext.getItem().getServerItem();
        final boolean isFolder = actionContext.getItem().isFolder();
        final String workingFolder = isFolder ? actionContext.getItem().getLocalItem() : Path.getDirectoryName((String)actionContext.getItem().getLocalItem());
        InternalBranchListProvider branchListProvider = new InternalBranchListProvider(serverContext, workingFolder);
        branchListProvider.getBranches(sourceDialogInput);
        MergeBranchDialog d = new MergeBranchDialog(project, serverContext, sourceDialogInput, isFolder, branchListProvider);
        if (!d.showAndGet()) {
            logger.info("User canceled");
            return;
        }
        final String sourceServerPath = d.getSourcePath();
        logger.info("sourceServerPath: " + sourceServerPath);
        final String targetServerPath = d.getTargetPath();
        logger.info("targetServerPath: " + targetServerPath);
        try {
            VcsUtil.runVcsProcessWithProgress((VcsRunnable)new VcsRunnable(){

                public void run() throws VcsException {
                    try {
                        Workspace workspace = CommandUtils.getWorkspace((ServerContext)serverContext, (Project)actionContext.getProject());
                        if (workspace == null) {
                            SingleItemAction.logger.info("Workspace not found");
                            throw new VcsException(TfPluginBundle.message("Errors.UnableToDetermineWorkspace", new Object[0]));
                        }
                        String targetLocalPath = CommandUtils.tryGetLocalPath((ServerContext)serverContext, (String)targetServerPath, (String)workspace.getName());
                        SingleItemAction.logger.info("targetLocalPath: " + targetLocalPath);
                        if (StringUtils.isEmpty((String)targetLocalPath)) {
                            SingleItemAction.logger.info("Target path not mapped in current workspace.");
                            throw new VcsException(TfPluginBundle.message("Actions.Tfvc.MergeBranch.Errors.NoMappingFound", targetServerPath, workspace.getName()));
                        }
                        MergeResults mergeResults = CommandUtils.merge((ServerContext)serverContext, (String)workingFolder, (String)sourceServerPath, (String)targetServerPath, null, (boolean)true);
                        if (mergeResults.noChangesToMerge()) {
                            SingleItemAction.logger.info("No changes to merge.");
                            throw new VcsException(TfPluginBundle.message("Actions.Tfvc.MergeBranch.Errors.NoChangesToMerge", sourceServerPath, targetServerPath));
                        }
                        if (mergeResults.errorsExist()) {
                            String errorString = StringUtils.join((Collection)mergeResults.getErrors(), (String)"; ");
                            SingleItemAction.logger.warn("Merge errors exist: " + errorString);
                            throw new VcsException(TfPluginBundle.message("Actions.Tfvc.MergeBranch.Errors.Found", errorString));
                        }
                        if (mergeResults.doConflictsExists()) {
                            SingleItemAction.logger.info("Conflicts found; launching the conflict resolution ui...");
                            ResolveConflictHelper resolveConflictHelper = new ResolveConflictHelper(project, null, Collections.singletonList(targetLocalPath), mergeResults);
                            try {
                                ConflictsEnvironment.getConflictsHandler().resolveConflicts(project, resolveConflictHelper);
                            }
                            catch (TfsException e) {
                                throw TFSVcs.convertToVcsException(e);
                            }
                        }
                        SingleItemAction.logger.info("Refreshing the virtual files...");
                        FilePath targetFilePath = VersionControlPath.getFilePath(targetLocalPath, isFolder);
                        for (VirtualFile root : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                            if (!targetFilePath.isUnder(TfsFileUtil.getFilePath(root), false)) continue;
                            TfsFileUtil.refreshAndInvalidate(project, new FilePath[]{targetFilePath}, true);
                            break;
                        }
                    }
                    catch (Throwable t) {
                        throw TFSVcs.convertToVcsException(t);
                    }
                }
            }, (String)TfPluginBundle.message("Actions.Tfvc.MergeBranch.Progress.Merging", new Object[0]), (boolean)false, (Project)project);
            String message = TfPluginBundle.message("Actions.Tfvc.MergeBranch.Success", sourceServerPath, targetServerPath);
            Messages.showInfoMessage((Project)project, (String)message, (String)title);
        }
        catch (Throwable t) {
            logger.warn("Merge Branches failed", t);
            Messages.showErrorDialog((Project)project, (String)t.getMessage(), (String)title);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionContext", "com/microsoft/alm/plugin/idea/tfvc/actions/MergeBranchAction", "execute"));
    }

    private static class InternalBranchListProvider
    implements MergeBranchDialog.BranchListProvider {
        private final String workingFolder;
        private final ServerContext serverContext;
        private String lastSourceUsed = null;
        private List<String> lastBranchesRetrieved = null;

        public InternalBranchListProvider(ServerContext serverContext, String workingFolder) {
            this.workingFolder = workingFolder;
            this.serverContext = serverContext;
        }

        @Override
        public List<String> getBranches(String source) {
            ArgumentHelper.checkNotEmptyString((String)source, (String)"source");
            if (!StringUtils.equalsIgnoreCase((String)this.lastSourceUsed, (String)source)) {
                this.lastBranchesRetrieved = CommandUtils.getBranches((ServerContext)this.serverContext, (String)this.workingFolder, (String)source);
                this.lastSourceUsed = source;
            }
            return this.lastBranchesRetrieved;
        }
    }
}

