/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.ChangeSet;
import com.microsoft.alm.plugin.external.models.CheckedInChange;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentRevision;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.ServerStatus;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusVisitor;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.VersionControlPath;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangelistBuilderStatusVisitor
implements StatusVisitor {
    private static final Logger logger = LoggerFactory.getLogger(ChangelistBuilderStatusVisitor.class);
    @NotNull
    private final Project project;
    @NotNull
    private final ChangelistBuilder changelistBuilder;

    public ChangelistBuilderStatusVisitor(@NotNull Project project, @NotNull ChangelistBuilder changelistBuilder) {
        if (project == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(0);
        }
        if (changelistBuilder == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.changelistBuilder = changelistBuilder;
    }

    @Override
    public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(2);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(3);
        }
        if (localItemExists) {
            TFSContentRevision baseRevision = TFSContentRevision.create(this.project, localPath, serverStatus.localVer, serverStatus.modicationDate);
            this.changelistBuilder.processChange(new Change((ContentRevision)baseRevision, CurrentContentRevision.create((FilePath)localPath)), TFSVcs.getKey());
        } else {
            this.changelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void locked(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(4);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(5);
        }
    }

    @Override
    public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(6);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(7);
        }
        if (localItemExists) {
            this.changelistBuilder.processChange(new Change(null, (ContentRevision)new CurrentContentRevision(localPath)), TFSVcs.getKey());
        } else {
            this.changelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(8);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(9);
        }
        TFSContentRevision baseRevision = TFSContentRevision.create(this.project, localPath, serverStatus.localVer, serverStatus.modicationDate);
        this.changelistBuilder.processChange(new Change((ContentRevision)baseRevision, null), TFSVcs.getKey());
    }

    @Override
    public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(10);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(11);
        }
        if (localItemExists) {
            TFSContentRevision before = this.getPreviousRenamedRevision(localPath, serverStatus.localVer);
            ContentRevision after = CurrentContentRevision.create((FilePath)localPath);
            this.changelistBuilder.processChange(new Change((ContentRevision)before, after), TFSVcs.getKey());
        } else {
            this.changelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(12);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(13);
        }
        if (localItemExists) {
            TFSContentRevision before = this.getPreviousRenamedRevision(localPath, serverStatus.localVer);
            ContentRevision after = CurrentContentRevision.create((FilePath)localPath);
            this.changelistBuilder.processChange(new Change((ContentRevision)before, after), TFSVcs.getKey());
        } else {
            this.changelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(14);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(15);
        }
        if (localItemExists) {
            VirtualFile filePath = localPath.getVirtualFile();
            if (filePath == null) {
                this.changelistBuilder.processLocallyDeletedFile(localPath);
            } else {
                this.changelistBuilder.processUnversionedFile(filePath);
            }
        }
    }

    @Override
    public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(16);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(17);
        }
        this.checkedOutForEdit(localPath, localItemExists, serverStatus);
    }

    private TFSContentRevision getPreviousRenamedRevision(FilePath localPath, int revision) {
        ServerContext serverContext = TFSVcs.getInstance(this.project).getServerContext(false);
        ChangeSet lastChangeSet = CommandUtils.getLastHistoryEntryForAnyUser((ServerContext)serverContext, (String)localPath.getPath());
        if (lastChangeSet != null && !lastChangeSet.getChanges().isEmpty()) {
            String serverPath = ((CheckedInChange)lastChangeSet.getChanges().get(0)).getServerItem();
            String originalPath = CommandUtils.getLocalPathSynchronously((ServerContext)serverContext, (String)serverPath, (String)CommandUtils.getWorkspaceName((Project)this.project));
            return TFSContentRevision.createRenameRevision(this.project, VersionControlPath.getFilePath(originalPath, localPath.isDirectory()), revision, lastChangeSet.getDate(), serverPath);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelistBuilder";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverStatus";
                break;
            }
        }
        objectArray2[1] = "com/microsoft/alm/plugin/idea/tfvc/core/ChangelistBuilderStatusVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkedOutForEdit";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "locked";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduledForAddition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduledForDeletion";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "renamedCheckedOut";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "renamed";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "unversioned";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "undeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

