/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentRevision;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSChangeList
implements CommittedChangeList {
    public static final Logger logger = LoggerFactory.getLogger(TFSChangeList.class);
    private static final SimpleDateFormat TFVC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private TFSVcs myVcs;
    private int changeSetId;
    private String author;
    private String changeSetDate;
    private int previousChangeSetId;
    private String previousChangeSetDate;
    @NotNull
    private String comment;
    private String workspaceName;
    private List<Change> changes;
    private final List<FilePath> addedFiles = new ArrayList<FilePath>();
    private final List<FilePath> deletedFiles = new ArrayList<FilePath>();
    private final List<FilePath> renamedFiles = new ArrayList<FilePath>();
    private final List<FilePath> editedFiles = new ArrayList<FilePath>();

    public TFSChangeList(TFSVcs vcs, DataInput stream) {
        this.myVcs = vcs;
        this.readFromStream(stream);
    }

    public TFSChangeList(List<FilePath> addedFiles, List<FilePath> deletedFiles, List<FilePath> renamedFiles, List<FilePath> editedFiles, int changeSetId, String author, String comment, String changeSetDate, int previousChangeSetId, String previousChangeSetDate, TFSVcs vcs, String workspaceName) {
        this.addedFiles.addAll(addedFiles);
        this.deletedFiles.addAll(deletedFiles);
        this.renamedFiles.addAll(renamedFiles);
        this.editedFiles.addAll(editedFiles);
        this.changeSetId = changeSetId;
        this.author = author;
        this.comment = comment != null ? comment : "";
        this.changeSetDate = changeSetDate;
        this.previousChangeSetId = previousChangeSetId;
        this.previousChangeSetDate = previousChangeSetDate;
        this.myVcs = vcs;
        this.workspaceName = workspaceName;
    }

    public String getCommitterName() {
        return this.author;
    }

    public Date getCommitDate() {
        Date formattedDate;
        block2: {
            formattedDate = null;
            try {
                formattedDate = TFVC_DATE_FORMAT.parse(this.changeSetDate);
            }
            catch (ParseException e) {
                logger.warn("Exception hit while parsing changeset date", (Throwable)e);
                if (formattedDate != null) break block2;
                logger.warn("Date could not be established so defaulting to now");
                formattedDate = Calendar.getInstance().getTime();
            }
        }
        return formattedDate;
    }

    public long getNumber() {
        return this.changeSetId;
    }

    @Nullable
    public String getBranch() {
        return null;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Collection<Change> getChanges() {
        if (this.changes == null) {
            this.changes = new ArrayList<Change>();
            logger.debug("Initializing the changes for the changeset: " + this.changeSetId);
            for (FilePath path : this.addedFiles) {
                this.changes.add(new Change(null, (ContentRevision)TFSContentRevision.create(this.myVcs.getProject(), path, this.changeSetId, this.changeSetDate)));
            }
            for (FilePath path : this.deletedFiles) {
                this.changes.add(new Change((ContentRevision)TFSContentRevision.create(this.myVcs.getProject(), path, this.previousChangeSetId, this.previousChangeSetDate), null));
            }
            for (FilePath path : this.renamedFiles) {
                this.changes.add(new Change(null, (ContentRevision)TFSContentRevision.create(this.myVcs.getProject(), path, this.changeSetId, this.changeSetDate)));
            }
            for (FilePath path : this.editedFiles) {
                TFSContentRevision before = TFSContentRevision.create(this.myVcs.getProject(), path, this.previousChangeSetId, this.previousChangeSetDate);
                TFSContentRevision after = TFSContentRevision.create(this.myVcs.getProject(), path, this.changeSetId, this.changeSetDate);
                this.changes.add(new Change((ContentRevision)before, (ContentRevision)after));
            }
        }
        return this.changes;
    }

    public Collection<Change> getChangesWithMovedTrees() {
        return this.getChanges();
    }

    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String newMessage) {
        this.comment = newMessage != null ? newMessage : "";
    }

    @NotNull
    public String getName() {
        String string = this.comment;
        if (string == null) {
            TFSChangeList.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getComment() {
        String string = this.comment;
        if (string == null) {
            TFSChangeList.$$$reportNull$$$0(1);
        }
        return string;
    }

    void writeToStream(DataOutput stream) throws IOException {
        TFSChangeList.writePaths(stream, this.addedFiles);
        TFSChangeList.writePaths(stream, this.deletedFiles);
        TFSChangeList.writePaths(stream, this.renamedFiles);
        TFSChangeList.writePaths(stream, this.editedFiles);
        stream.writeInt(this.changeSetId);
        stream.writeUTF(this.author);
        stream.writeUTF(this.comment);
        stream.writeUTF(this.changeSetDate);
        stream.writeInt(this.previousChangeSetId);
        stream.writeUTF(this.previousChangeSetDate);
        stream.writeUTF(this.workspaceName);
    }

    private void readFromStream(DataInput stream) {
        try {
            TFSChangeList.readPaths(stream, this.addedFiles);
            TFSChangeList.readPaths(stream, this.deletedFiles);
            TFSChangeList.readPaths(stream, this.renamedFiles);
            TFSChangeList.readPaths(stream, this.editedFiles);
            this.changeSetId = stream.readInt();
            this.author = stream.readUTF();
            this.comment = stream.readUTF();
            this.changeSetDate = stream.readUTF();
            this.previousChangeSetId = stream.readInt();
            this.previousChangeSetDate = stream.readUTF();
            this.workspaceName = stream.readUTF();
        }
        catch (IOException e) {
            logger.warn("Error reading changelist from stream", (Throwable)e);
            this.author = StringUtils.isEmpty((String)this.author) ? "" : this.author;
            this.comment = StringUtils.isEmpty((String)this.comment) ? "" : this.comment;
            this.changeSetDate = StringUtils.isEmpty((String)this.changeSetDate) ? "" : this.changeSetDate;
            this.previousChangeSetDate = StringUtils.isEmpty((String)this.previousChangeSetDate) ? "" : this.previousChangeSetDate;
            this.workspaceName = StringUtils.isEmpty((String)this.workspaceName) ? "" : this.workspaceName;
            AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).showError(new VcsException((Throwable)e), "TFVC");
        }
    }

    private static void writePaths(DataOutput stream, Collection<FilePath> paths) throws IOException {
        stream.writeInt(paths.size());
        for (FilePath path : paths) {
            TFSChangeList.writePath(stream, path);
        }
    }

    private static void writePath(DataOutput stream, FilePath path) throws IOException {
        stream.writeUTF(path.getPath());
        stream.writeBoolean(path.isDirectory());
    }

    private static void readPaths(DataInput stream, Collection<FilePath> paths) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            paths.add(TFSChangeList.readPath(stream));
        }
    }

    private static FilePath readPath(DataInput stream) throws IOException {
        return VcsUtil.getFilePath((String)stream.readUTF(), (boolean)stream.readBoolean());
    }

    public String toString() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TFSChangeList that = (TFSChangeList)o;
        if (this.changeSetId != that.changeSetId) {
            return false;
        }
        if (this.author != null ? !this.author.equals(that.author) : that.author != null) {
            return false;
        }
        if (this.changeSetDate != null ? !this.changeSetDate.equals(that.changeSetDate) : that.changeSetDate != null) {
            return false;
        }
        return !(this.workspaceName != null ? !this.workspaceName.equals(that.workspaceName) : that.workspaceName != null);
    }

    public int hashCode() {
        int result = this.changeSetId;
        result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
        result = 31 * result + (this.changeSetDate != null ? this.changeSetDate.hashCode() : 0);
        result = 31 * result + (this.workspaceName != null ? this.workspaceName.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/microsoft/alm/plugin/idea/tfvc/core/TFSChangeList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

