/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.rest.VersionControlRecursionTypeCaseSensitive;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentRevision;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsRevisionNumber;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcItem;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcVersionDescriptor;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcVersionType;
import java.io.File;
import java.util.Calendar;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSDiffProvider
implements DiffProvider {
    private static final Logger logger = LoggerFactory.getLogger(TFSDiffProvider.class);
    private static final int MINIMAL_WAIT_FOR_RETRY = 60000;
    private final Project project;
    private List<Workspace.Mapping> mappings;
    private Calendar lastUpdated;

    public TFSDiffProvider(@NotNull Project project) {
        if (project == null) {
            TFSDiffProvider.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    @Nullable
    public ItemLatestState getLastRevision(VirtualFile virtualFile) {
        FilePath localPath = TfsFileUtil.getFilePath(virtualFile);
        return this.getLastRevision(localPath);
    }

    @Nullable
    public ContentRevision createFileContent(VcsRevisionNumber vcsRevisionNumber, VirtualFile virtualFile) {
        if (VcsRevisionNumber.NULL.equals(vcsRevisionNumber)) {
            return null;
        }
        FilePath path = TfsFileUtil.getFilePath(virtualFile);
        try {
            return TFSContentRevision.create(this.project, path, this.getChangeset(vcsRevisionNumber), this.getModificationDate(vcsRevisionNumber));
        }
        catch (Exception e) {
            logger.warn("Unable to create file content", (Throwable)e);
            AbstractVcsHelper.getInstance((Project)this.project).showError(new VcsException((Throwable)e), "TFVC");
            return null;
        }
    }

    private String getModificationDate(VcsRevisionNumber vcsRevisionNumber) {
        if (vcsRevisionNumber instanceof TfsRevisionNumber) {
            TfsRevisionNumber revisionNumber = (TfsRevisionNumber)vcsRevisionNumber;
            return revisionNumber.getModificationDate();
        }
        return "";
    }

    private int getChangeset(VcsRevisionNumber vcsRevisionNumber) {
        if (vcsRevisionNumber instanceof VcsRevisionNumber.Int) {
            VcsRevisionNumber.Int revisionNumber = (VcsRevisionNumber.Int)vcsRevisionNumber;
            return revisionNumber.getValue();
        }
        return 0;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(VirtualFile virtualFile) {
        try {
            File localFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            return this.getRevisionNumber(localFile.getPath(), localFile.getName());
        }
        catch (Exception e) {
            logger.warn("Unable to getCurrentRevision", (Throwable)e);
            AbstractVcsHelper.getInstance((Project)this.project).showError(new VcsException(LocalizationServiceImpl.getInstance().getExceptionMessage(e), (Throwable)e), "TFVC");
            return VcsRevisionNumber.NULL;
        }
    }

    public ItemLatestState getLastRevision(FilePath localPath) {
        try {
            File localFile = localPath.getIOFile();
            VcsRevisionNumber revisionNumber = this.getRevisionNumber(localFile.getPath(), localFile.getName());
            if (revisionNumber != VcsRevisionNumber.NULL) {
                return new ItemLatestState(revisionNumber, true, false);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to getLastRevision", (Throwable)e);
            AbstractVcsHelper.getInstance((Project)this.project).showError(new VcsException(LocalizationServiceImpl.getInstance().getExceptionMessage(e), (Throwable)e), "TFVC");
        }
        return new ItemLatestState(VcsRevisionNumber.NULL, false, false);
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }

    private VcsRevisionNumber getRevisionNumber(String filePath, String fileName) {
        TfvcVersionDescriptor versionDescriptor = new TfvcVersionDescriptor();
        versionDescriptor.setVersionType(TfvcVersionType.LATEST);
        ServerContext context = TFSVcs.getInstance(this.project).getServerContext(true);
        List item = context.getTfvcHttpClient().getItems(context.getTeamProjectReference().getId(), TfsFileUtil.translateLocalItemToServerItem(filePath, this.getUpdatedMappings()), VersionControlRecursionTypeCaseSensitive.NONE, versionDescriptor);
        if (!item.isEmpty() && item.get(0) != null) {
            return new TfsRevisionNumber(((TfvcItem)item.get(0)).getChangesetVersion(), fileName, ((TfvcItem)item.get(0)).getChangeDate().toString());
        }
        return VcsRevisionNumber.NULL;
    }

    private List<Workspace.Mapping> getUpdatedMappings() {
        if (this.mappings == null || this.lastUpdated == null || Calendar.getInstance().getTimeInMillis() - this.lastUpdated.getTimeInMillis() > 60000L) {
            this.updateMappings();
        }
        return this.mappings;
    }

    public void updateMappings() {
        Workspace workspace = CommandUtils.getPartialWorkspace((Project)this.project);
        this.mappings = workspace.getMappings();
        this.lastUpdated = Calendar.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/microsoft/alm/plugin/idea/tfvc/core/TFSDiffProvider", "<init>"));
    }
}

