/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.SyncResults;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSProgressUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.conflicts.ConflictsEnvironment;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.conflicts.ResolveConflictHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSUpdateEnvironment
implements UpdateEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(TFSUpdateEnvironment.class);
    @NotNull
    private final TFSVcs tfsVcs;

    TFSUpdateEnvironment(@NotNull TFSVcs vcs) {
        if (vcs == null) {
            TFSUpdateEnvironment.$$$reportNull$$$0(0);
        }
        this.tfsVcs = vcs;
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] contentRoots, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> context) throws ProcessCanceledException {
        if (contentRoots == null) {
            TFSUpdateEnvironment.$$$reportNull$$$0(1);
        }
        if (context == null) {
            TFSUpdateEnvironment.$$$reportNull$$$0(2);
        }
        logger.info("Update on files initiated...");
        final ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        TFSProgressUtil.setProgressText(progressIndicator, TfPluginBundle.message("Tfvc.Update.Status.Msg", new Object[0]));
        try {
            ArrayList<String> filesUpdatePaths = new ArrayList<String>(contentRoots.length);
            boolean needRecursion = false;
            for (FilePath file : contentRoots) {
                needRecursion = file.isDirectory() ? true : needRecursion;
                filesUpdatePaths.add(file.getPath());
            }
            SyncResults results = CommandUtils.syncWorkspace((ServerContext)this.tfsVcs.getServerContext(false), filesUpdatePaths, (boolean)needRecursion, (boolean)false);
            for (String file : results.getDeletedFiles()) {
                updatedFiles.getGroupById("REMOVED_FROM_REPOSITORY").add(file, TFSVcs.getKey(), null);
            }
            for (String file : results.getNewFiles()) {
                updatedFiles.getGroupById("CREATED").add(file, TFSVcs.getKey(), null);
            }
            for (String file : results.getUpdatedFiles()) {
                updatedFiles.getGroupById("UPDATED").add(file, TFSVcs.getKey(), null);
            }
            if (results.doConflictsExists()) {
                logger.info("Conflicts found during update");
                ResolveConflictHelper conflictHelper = new ResolveConflictHelper(this.tfsVcs.getProject(), updatedFiles, filesUpdatePaths);
                ConflictsEnvironment.getConflictsHandler().resolveConflicts(this.tfsVcs.getProject(), conflictHelper);
            }
            if (!results.getExceptions().isEmpty()) {
                for (Exception e : results.getExceptions()) {
                    exceptions.add(TFSVcs.convertToVcsException(e));
                }
            }
        }
        catch (Exception e) {
            exceptions.add(TFSVcs.convertToVcsException(e));
        }
        TfsFileUtil.refreshAndInvalidate(this.tfsVcs.getProject(), contentRoots, false);
        UpdateSession updateSession = new UpdateSession(){

            @NotNull
            public List<VcsException> getExceptions() {
                List list = exceptions;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            public void onRefreshFilesCompleted() {
            }

            public boolean isCanceled() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/microsoft/alm/plugin/idea/tfvc/core/TFSUpdateEnvironment$1", "getExceptions"));
            }
        };
        if (updateSession == null) {
            TFSUpdateEnvironment.$$$reportNull$$$0(3);
        }
        return updateSession;
    }

    @Nullable
    public Configurable createConfigurable(Collection<FilePath> files) {
        return null;
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/microsoft/alm/plugin/idea/tfvc/core/TFSUpdateEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/microsoft/alm/plugin/idea/tfvc/core/TFSUpdateEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectories";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

