/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.revision;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.commands.DownloadCommand;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentStore;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSTmpFileStore;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSContentStoreFactory {
    private static final Logger logger = LoggerFactory.getLogger(TFSContentStoreFactory.class);

    public static TFSContentStore create(String localPath, int revision) throws IOException {
        return new TFSTmpFileStore(localPath, revision);
    }

    @Nullable
    public static TFSContentStore find(String localPath, int revision) throws IOException {
        return TFSTmpFileStore.find(localPath, revision);
    }

    public static TFSContentStore findOrCreate(String localPath, int revision, String actualPath, Project project) throws IOException {
        TFSContentStore store = TFSContentStoreFactory.find(localPath, revision);
        if (store == null) {
            try {
                store = TFSContentStoreFactory.create(localPath, revision);
                ServerContext serverContext = TFSVcs.getInstance(project).getServerContext(false);
                DownloadCommand command = new DownloadCommand(serverContext, actualPath, revision, store.getTmpFile().getPath(), true);
                command.runSynchronously();
            }
            catch (Throwable t) {
                logger.warn("Unable to download content for a TFVC file.", t);
            }
        }
        return store;
    }
}

