/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.tfs;

import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsRevisionNumber
extends VcsRevisionNumber.Int {
    private static final Logger logger = LoggerFactory.getLogger(TfsRevisionNumber.class);
    private static final String SEPARATOR = "/";
    private final String fileName;
    private final String modificationDate;

    public TfsRevisionNumber(int value, String fileName, String modificationDate) {
        super(value);
        this.fileName = fileName;
        this.modificationDate = modificationDate;
    }

    public String asString() {
        return String.valueOf(this.getValue()) + SEPARATOR + this.fileName + SEPARATOR + this.modificationDate;
    }

    public static TfsRevisionNumber tryParse(String s) {
        try {
            String[] sections = StringUtils.split((String)s, (String)SEPARATOR);
            if (sections == null || sections.length != 3) {
                return null;
            }
            return new TfsRevisionNumber(Integer.parseInt(sections[0]), sections[1], sections[2]);
        }
        catch (NumberFormatException e) {
            logger.error("Could not parse revision number: " + s, (Throwable)e);
            return null;
        }
    }

    public String getChangesetString() {
        return String.valueOf(this.getValue());
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getModificationDate() {
        return this.modificationDate;
    }
}

