/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.tfs.conflicts;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.conflicts.ContentMerger;
import com.microsoft.alm.plugin.idea.tfvc.ui.resolve.ContentTriplet;
import java.io.File;

public class DialogContentMerger
implements ContentMerger {
    @Override
    public boolean mergeContent(ContentTriplet contentTriplet, Project project, final VirtualFile localFile, VcsRevisionNumber serverVersion) {
        ArgumentHelper.checkIfFileWriteable((File)new File(localFile.getPath()));
        MergeDialogCustomizer c = new MergeDialogCustomizer();
        MergeRequest request = DiffRequestFactory.getInstance().createMergeRequest(StreamUtil.convertSeparators((String)contentTriplet.localContent), StreamUtil.convertSeparators((String)contentTriplet.serverContent), StreamUtil.convertSeparators((String)contentTriplet.baseContent), localFile, project, ActionButtonPresentation.APPLY, ActionButtonPresentation.CANCEL_WITH_PROMPT);
        request.setWindowTitle(c.getMergeWindowTitle(localFile));
        request.setVersionTitles(new String[]{c.getLeftPanelTitle(localFile), c.getCenterPanelTitle(localFile), c.getRightPanelTitle(localFile, serverVersion)});
        DiffManager.getInstance().getDiffTool().show((DiffRequest)request);
        if (request.getResult() == 0) {
            return true;
        }
        request.restoreOriginalContent();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Document document = FileDocumentManager.getInstance().getDocument(localFile);
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            }
        });
        return false;
    }
}

