/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.openapi.project.Project;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.idea.tfvc.ui.LabelItemsTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ApplyLabelForm {
    private final Project project;
    private final List<ItemInfo> itemInfos;
    private JPanel contentPane;
    private JTextField nameText;
    private JTextArea commentTextArea;
    private JTable itemsTable;
    private JButton addButton;
    private JButton removeButton;
    private JCheckBox recursiveCheckBox;
    private LabelItemsTableModel itemsTableModel;
    private final EventDispatcher<Listener> eventDispatcher;

    public ApplyLabelForm(Project project, List<ItemInfo> itemInfos) {
        this.$$$setupUI$$$();
        this.eventDispatcher = EventDispatcher.create(Listener.class);
        this.project = project;
        this.itemInfos = itemInfos;
        this.nameText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((Listener)ApplyLabelForm.this.eventDispatcher.getMulticaster()).dataChanged(ApplyLabelForm.this.getLabelName(), ApplyLabelForm.this.itemsTableModel.getRowCount());
            }
        });
        this.addButton.setVisible(false);
        this.removeButton.setVisible(false);
        this.initTable();
        this.updateButtons();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.nameText;
    }

    private void initTable() {
        this.itemsTableModel = new LabelItemsTableModel();
        this.itemsTableModel.setItems(this.itemInfos);
        this.itemsTable.setModel(this.itemsTableModel);
        for (int i = 0; i < LabelItemsTableModel.Column.values().length; ++i) {
            this.itemsTable.getColumnModel().getColumn(i).setPreferredWidth(LabelItemsTableModel.Column.values()[i].getWidth());
            if (i <= 0) continue;
            DefaultTableCellRenderer typeRenderer = new DefaultTableCellRenderer();
            typeRenderer.setHorizontalAlignment(0);
            this.itemsTable.getColumnModel().getColumn(i).setCellRenderer(typeRenderer);
        }
        this.itemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ApplyLabelForm.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public String getLabelName() {
        return this.nameText.getText().trim();
    }

    public String getLabelComment() {
        return this.commentTextArea.getText();
    }

    public boolean isRecursiveChecked() {
        return this.recursiveCheckBox.isSelected();
    }

    public List<String> getLabelItemSpecs() {
        ArrayList<String> itemSpecs = new ArrayList<String>();
        for (ItemInfo info : this.itemInfos) {
            itemSpecs.add(info.getServerItem() + ";" + info.getServerVersion());
        }
        return itemSpecs;
    }

    public void addListener(Listener listener) {
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.eventDispatcher.addListener((EventListener)listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextArea jTextArea;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.NameLabel"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.nameText = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.CommentLabel"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.ItemsLabel"));
        jPanel.add((Component)jLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.addButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.AddButton"));
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.removeButton = jButton = new JButton();
        ((Component)jButton).setEnabled(false);
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.RemoveButton"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(6, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(-1, 250), null));
        JBTable jBTable = new JBTable();
        this.itemsTable = jBTable;
        jBScrollPane.setViewportView((Component)jBTable);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.commentTextArea = jTextArea = new JTextArea();
        jTextArea.setRows(4);
        jBScrollPane2.setViewportView(jTextArea);
        this.recursiveCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.RecursiveCheckBox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Listener
    extends EventListener {
        public void dataChanged(String var1, int var2);
    }
}

