/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.external.commands.LockCommand;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.tfvc.ui.LockItemsForm;
import com.microsoft.alm.plugin.idea.tfvc.ui.LockItemsTableModel;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LockItemsDialog
extends BaseDialogImpl {
    public static final String PROP_ITEMS = "items";
    public static final int LOCK_EXIT_CODE = 2;
    public static final int UNLOCK_EXIT_CODE = 3;
    private LockItemsForm form;
    private Action lockAction;
    private Action unlockAction;

    public LockItemsDialog(Project project, List<ItemInfo> items) {
        super(project, TfPluginBundle.message("Tfvc.Lock.Dialog.Title", new Object[0]), null, "Tfvc.Lock.Dialog.Title", true, Collections.singletonMap(PROP_ITEMS, items));
        this.updateControls();
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        this.form = new LockItemsForm((List)this.getProperty(PROP_ITEMS));
        this.form.addListener(new LockItemsTableModel.Listener(){

            @Override
            public void selectionChanged() {
                LockItemsDialog.this.updateControls();
            }
        });
        return this.form.getContentPane();
    }

    @NotNull
    protected Action[] createActions() {
        this.lockAction = new LockAction();
        this.unlockAction = new UnlockAction();
        Action[] actionArray = new Action[]{this.lockAction, this.unlockAction, this.getCancelAction()};
        if (actionArray == null) {
            LockItemsDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    private void setLockActionEnabled(boolean isEnabled) {
        if (this.lockAction != null) {
            this.lockAction.setEnabled(isEnabled);
            this.form.setRadioButtonsEnabled(isEnabled);
        }
    }

    private void setUnlockActionEnabled(boolean isEnabled) {
        if (this.unlockAction != null) {
            this.unlockAction.setEnabled(isEnabled);
        }
    }

    private void updateControls() {
        List<ItemInfo> items = this.getSelectedItems();
        this.setLockActionEnabled(!items.isEmpty() && LockItemsDialog.canAllBeLocked(items));
        this.setUnlockActionEnabled(!items.isEmpty() && LockItemsDialog.canAllBeUnlocked(items));
    }

    private static boolean canAllBeLocked(List<ItemInfo> items) {
        for (ItemInfo item : items) {
            LockCommand.LockLevel level = LockCommand.LockLevel.fromString((String)item.getLock());
            if (level == LockCommand.LockLevel.NONE) continue;
            return false;
        }
        return true;
    }

    private static boolean canAllBeUnlocked(List<ItemInfo> items) {
        for (ItemInfo item : items) {
            LockCommand.LockLevel level = LockCommand.LockLevel.fromString((String)item.getLock());
            if (level != LockCommand.LockLevel.NONE) continue;
            return false;
        }
        return true;
    }

    public List<ItemInfo> getSelectedItems() {
        return this.form.getSelectedItems();
    }

    public LockCommand.LockLevel getLockLevel() {
        return this.form.getLockLevel();
    }

    public boolean getRecursive() {
        return this.form.getRecursive();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/microsoft/alm/plugin/idea/tfvc/ui/LockItemsDialog", "createActions"));
    }

    private class UnlockAction
    extends AbstractAction {
        public UnlockAction() {
            super(TfPluginBundle.message("Tfvc.Lock.Dialog.UnlockButton", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LockItemsDialog.this.myPerformAction) {
                return;
            }
            try {
                LockItemsDialog.this.myPerformAction = true;
                if (this.isEnabled()) {
                    LockItemsDialog.this.close(3);
                }
            }
            finally {
                LockItemsDialog.this.myPerformAction = false;
            }
        }
    }

    private class LockAction
    extends AbstractAction {
        public LockAction() {
            super(TfPluginBundle.message("Tfvc.Lock.Dialog.LockButton", new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LockItemsDialog.this.myPerformAction) {
                return;
            }
            try {
                LockItemsDialog.this.myPerformAction = true;
                if (this.isEnabled()) {
                    LockItemsDialog.this.close(2);
                }
            }
            finally {
                LockItemsDialog.this.myPerformAction = false;
            }
        }
    }
}

