/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.tfvc.ui.ProxySettingsForm;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ProxySettingsDialog
extends BaseDialogImpl {
    private static final String PROP_PROXY_URI = "proxyUri";
    private ProxySettingsForm form;

    public ProxySettingsDialog(Project project, String serverUri, String proxyUri) {
        super(project, TfPluginBundle.message("Tfvc.Proxy.Dialog.Title", serverUri), TfPluginBundle.message("Tfvc.Proxy.Dialog.OkButton", new Object[0]), "Tfvc.Proxy.Dialog.Title", true, Collections.singletonMap(PROP_PROXY_URI, proxyUri));
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        this.form = new ProxySettingsForm((String)this.getProperty(PROP_PROXY_URI));
        return this.form.getContentPane();
    }

    private void updateButtons() {
        String errorMessage = this.form.isValid() ? null : TfPluginBundle.message("Tfvc.Proxy.Dialog.Errors.InvalidURI", new Object[0]);
        this.form.setMessage(errorMessage);
        this.setOkEnabled(this.form.isValid());
    }

    @Override
    protected void doOKAction() {
        if (this.form.isValid()) {
            super.doOKAction();
        } else {
            this.updateButtons();
            this.form.addListener(new ProxySettingsForm.Listener(){

                @Override
                public void stateChanged() {
                    ProxySettingsDialog.this.updateButtons();
                }
            });
        }
    }

    @Nullable
    public String getProxyUri() {
        return this.form.getProxyUri();
    }
}

