/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.microsoft.alm.common.utils.UrlHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ProxySettingsForm {
    private JPanel myContentPane;
    private JRadioButton noProxyRadio;
    private JRadioButton useProxyRadio;
    private JTextField addressText;
    private JLabel messageLabel;
    private JLabel infoLabel;
    private JLabel addressLabel;
    private final EventDispatcher<Listener> myEventDispatcher;

    public ProxySettingsForm(String initialProxyUri) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        if (StringUtils.isEmpty((String)initialProxyUri)) {
            this.noProxyRadio.setSelected(true);
        } else {
            this.useProxyRadio.setSelected(true);
            this.addressText.setText(initialProxyUri.toString());
        }
        ActionListener radioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsForm.this.updateContols();
                ((Listener)ProxySettingsForm.this.myEventDispatcher.getMulticaster()).stateChanged();
            }
        };
        this.noProxyRadio.addActionListener(radioButtonListener);
        this.useProxyRadio.addActionListener(radioButtonListener);
        this.addressText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((Listener)ProxySettingsForm.this.myEventDispatcher.getMulticaster()).stateChanged();
            }
        });
        this.infoLabel.setText("");
        this.updateContols();
    }

    private void updateContols() {
        this.addressText.setEnabled(this.useProxyRadio.isSelected());
        this.infoLabel.setEnabled(this.useProxyRadio.isSelected());
        this.addressLabel.setEnabled(this.useProxyRadio.isSelected());
        if (this.useProxyRadio.isSelected()) {
            this.addressText.requestFocus();
        }
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    public boolean isValid() {
        return this.noProxyRadio.isSelected() || UrlHelper.isValidUrl((String)this.addressText.getText());
    }

    @Nullable
    public String getProxyUri() {
        if (this.noProxyRadio.isSelected()) {
            return null;
        }
        return this.addressText.getText().trim();
    }

    public void setMessage(@Nullable String message) {
        this.messageLabel.setText(message);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JLabel jLabel3;
        JTextField jTextField;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.addressText = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.addressLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ProxySettingsDialog.Address"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.useProxyRadio = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ProxySettingsDialog.UseProxy"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.noProxyRadio = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ProxySettingsDialog.NoProxy"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.messageLabel = jLabel2 = new JLabel();
        ((Component)jLabel2).setForeground(new Color(-65536));
        jLabel2.setText(" ");
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 0, new Dimension(300, -1), null, null));
        this.infoLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Listener
    extends EventListener {
        public void stateChanged();
    }
}

