/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.checkout;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.commands.CreateWorkspaceCommand;
import com.microsoft.alm.plugin.external.commands.DeleteWorkspaceCommand;
import com.microsoft.alm.plugin.external.commands.ToolEulaNotAcceptedException;
import com.microsoft.alm.plugin.external.commands.UpdateWorkspaceMappingCommand;
import com.microsoft.alm.plugin.external.exceptions.WorkspaceAlreadyExistsException;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.idea.common.ui.checkout.VcsSpecificCheckoutModel;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.ui.settings.EULADialog;
import com.microsoft.alm.plugin.idea.tfvc.ui.workspace.WorkspaceController;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfvcCheckoutModel
implements VcsSpecificCheckoutModel {
    private static final Logger logger = LoggerFactory.getLogger(TfvcCheckoutModel.class);

    @Override
    public void doCheckout(final Project project, final CheckoutProvider.Listener listener, final ServerContext context, final VirtualFile destinationParent, final String directoryName, final String parentDirectory, final boolean isAdvancedChecked) {
        final String workspaceName = directoryName;
        final String teamProjectName = this.getRepositoryName(context);
        final String localPath = Path.combine((String)parentDirectory, (String)directoryName);
        final AtomicBoolean checkoutResult = new AtomicBoolean();
        new Task.Backgroundable(project, TfPluginBundle.message("CheckoutDialog.Tfvc.CreatingWorkspace", new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeaHelper.setProgress(indicator, 0.1, TfPluginBundle.message("CheckoutDialog.Tfvc.Progress.Creating", new Object[0]));
                try {
                    CreateWorkspaceCommand command = new CreateWorkspaceCommand(context, workspaceName, TfPluginBundle.message("CheckoutDialog.Tfvc.WorkspaceComment", new Object[0]), null, null);
                    command.runSynchronously();
                }
                catch (ToolEulaNotAcceptedException e) {
                    logger.error("EULA not accepted");
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            EULADialog.showDialogIfNeeded(project);
                        }
                    });
                    return;
                }
                catch (WorkspaceAlreadyExistsException e) {
                    logger.warn("Error creating workspace: " + LocalizationServiceImpl.getInstance().getExceptionMessage(e));
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)LocalizationServiceImpl.getInstance().getExceptionMessage((Throwable)e), (String)TfPluginBundle.message("CheckoutDialog.Tfvc.Failed.Title", new Object[0]));
                        }
                    });
                    return;
                }
                IdeaHelper.setProgress(indicator, 0.2, TfPluginBundle.message("CheckoutDialog.Tfvc.Progress.AddRoot", new Object[0]));
                String serverPath = "$/" + teamProjectName;
                try {
                    UpdateWorkspaceMappingCommand mappingCommand = new UpdateWorkspaceMappingCommand(context, workspaceName, new Workspace.Mapping(serverPath, localPath, false), false);
                    mappingCommand.runSynchronously();
                }
                catch (RuntimeException e) {
                    logger.warn("Error while mapping workspace during creation", (Throwable)e);
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)LocalizationServiceImpl.getInstance().getExceptionMessage(e), (String)TfPluginBundle.message("CheckoutDialog.Tfvc.Failed.Title", new Object[0]));
                        }
                    });
                    DeleteWorkspaceCommand deleteWorkspaceCommand = new DeleteWorkspaceCommand(context, workspaceName);
                    deleteWorkspaceCommand.runSynchronously();
                    return;
                }
                IdeaHelper.setProgress(indicator, 0.3, TfPluginBundle.message("CheckoutDialog.Tfvc.Progress.CreateFolder", new Object[0]));
                File file = new File(localPath);
                if (!file.mkdirs()) {
                    // empty if block
                }
                if (!isAdvancedChecked) {
                    IdeaHelper.setProgress(indicator, 0.5, TfPluginBundle.message("CheckoutDialog.Tfvc.Progress.Sync", new Object[0]));
                    CommandUtils.syncWorkspace((ServerContext)context, (String)localPath);
                }
                IdeaHelper.setProgress(indicator, 1.0, "", true);
                checkoutResult.set(true);
            }

            public void onSuccess() {
                if (checkoutResult.get()) {
                    if (isAdvancedChecked) {
                        RepositoryContext repositoryContext = RepositoryContext.createTfvcContext((String)localPath, (String)workspaceName, (String)teamProjectName, (String)context.getServerUri().toString());
                        WorkspaceController controller = new WorkspaceController(project, repositoryContext, context, workspaceName);
                        if (controller.showModalDialog(false)) {
                            controller.saveWorkspace(localPath, true, new Runnable(){

                                @Override
                                public void run() {
                                    TfvcCheckoutModel.this.UpdateVersionControlSystem(project, parentDirectory, directoryName, destinationParent, listener);
                                }
                            });
                        }
                    } else {
                        TfvcCheckoutModel.this.UpdateVersionControlSystem(project, parentDirectory, directoryName, destinationParent, listener);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/microsoft/alm/plugin/idea/tfvc/ui/checkout/TfvcCheckoutModel$1", "run"));
            }
        }.queue();
    }

    private void UpdateVersionControlSystem(final Project project, String parentDirectory, String directoryName, final VirtualFile destinationParent, CheckoutProvider.Listener listener) {
        DvcsUtil.addMappingIfSubRoot((Project)project, (String)FileUtil.join((String[])new String[]{parentDirectory, directoryName}), (String)"TFVC");
        destinationParent.refresh(true, true, new Runnable(){

            @Override
            public void run() {
                if (project.isOpen() && !project.isDisposed() && !project.isDefault()) {
                    VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
                    mgr.fileDirty(destinationParent);
                }
            }
        });
        listener.directoryCheckedOut(new File(parentDirectory, directoryName), TFSVcs.getKey());
        listener.checkoutCompleted();
    }

    @Override
    public String getButtonText() {
        return TfPluginBundle.message("CheckoutDialog.CreateWorkspaceButton", new Object[0]);
    }

    @Override
    public String getRepositoryName(ServerContext context) {
        return context != null && context.getTeamProjectReference() != null ? context.getTeamProjectReference().getName() : "";
    }

    @Override
    public RepositoryContext.Type getRepositoryType() {
        return RepositoryContext.Type.TFVC;
    }
}

