/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.management;

import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.external.models.Server;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ActionListenerContainer;
import com.microsoft.alm.plugin.idea.common.ui.common.treetable.CellRenderer;
import com.microsoft.alm.plugin.idea.common.ui.common.treetable.ContentProvider;
import com.microsoft.alm.plugin.idea.common.ui.common.treetable.CustomTreeTable;
import com.microsoft.alm.plugin.idea.common.ui.common.treetable.TreeTableColumn;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageWorkspacesForm {
    private final Logger logger = LoggerFactory.getLogger(ManageWorkspacesForm.class);
    public static final String CMD_RELOAD_WORKSPACES = "reloadWorkspaces";
    public static final String CMD_EDIT_WORKSPACE = "editWorkspace";
    public static final String CMD_DELETE_WORKSPACE = "deleteWorkspace";
    public static final String CMD_EDIT_PROXY = "editProxy";
    private static final TreeTableColumn<Object> COLUMN_SERVER_WORKSPACE = new TreeTableColumn<Object>(TfPluginBundle.message("Tfvc.ManageWorkspaces.Mixed.Column", new Object[0]), 200){

        @Override
        public String getPresentableString(Object value) {
            if (value instanceof Server) {
                return ((Server)value).getName();
            }
            if (value instanceof Workspace) {
                return ((Workspace)value).getName();
            }
            return "";
        }
    };
    private static final TreeTableColumn<Object> COLUMN_SERVER = new TreeTableColumn<Object>(TfPluginBundle.message("Tfvc.ManageWorkspaces.Server.Column", new Object[0]), 200){

        @Override
        public String getPresentableString(Object value) {
            if (value instanceof Server) {
                return ((Server)value).getName();
            }
            return "";
        }
    };
    private static final TreeTableColumn<Object> COLUMN_COMMENT = new TreeTableColumn<Object>(TfPluginBundle.message("Tfvc.ManageWorkspaces.Comment.Column", new Object[0]), 100){

        @Override
        public String getPresentableString(Object value) {
            if (value instanceof Workspace) {
                return ((Workspace)value).getComment();
            }
            return "";
        }
    };
    private JPanel contentPane;
    private JButton proxySettingsButton;
    private JButton editWorkspaceButton;
    private JButton deleteWorkspaceButton;
    private CustomTreeTable<Object> treeTable;
    private JPanel workspacesPanel;
    private JButton reloadWorkspacesButton;
    private boolean isShowWorkspaces = true;
    private final EventDispatcher<Listener> eventDispatcher = EventDispatcher.create(Listener.class);
    private final ContentProvider<Object> contentProvider;
    private final ActionListenerContainer listenerContainer = new ActionListenerContainer();
    private final ListSelectionListener selectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ManageWorkspacesForm.this.updateButtons();
            ((Listener)ManageWorkspacesForm.this.eventDispatcher.getMulticaster()).selectionChanged();
        }
    };

    public ManageWorkspacesForm(ContentProvider<Object> contentProvider) {
        this.contentProvider = contentProvider;
        this.$$$setupUI$$$();
        this.updateButtons();
        this.reloadWorkspacesButton.setActionCommand(CMD_RELOAD_WORKSPACES);
        this.editWorkspaceButton.setActionCommand(CMD_EDIT_WORKSPACE);
        this.deleteWorkspaceButton.setActionCommand(CMD_DELETE_WORKSPACE);
        this.proxySettingsButton.setActionCommand(CMD_EDIT_PROXY);
    }

    public void addActionListener(ActionListener listener) {
        this.proxySettingsButton.addActionListener(listener);
        this.editWorkspaceButton.addActionListener(listener);
        this.deleteWorkspaceButton.addActionListener(listener);
        this.reloadWorkspacesButton.addActionListener(listener);
        this.listenerContainer.add(listener);
    }

    private void createUIComponents() {
        this.treeTable = new CustomTreeTable<Object>(new CellRendererImpl(), false, true);
        this.treeTable.getSelectionModel().setSelectionMode(0);
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getClickCount() == 2) {
                    ManageWorkspacesForm.this.listenerContainer.triggerEvent(this, ManageWorkspacesForm.CMD_EDIT_WORKSPACE);
                }
            }
        });
    }

    public void setShowWorkspaces(boolean showWorkspaces) {
        this.isShowWorkspaces = showWorkspaces;
        this.workspacesPanel.setVisible(this.isShowWorkspaces);
        this.reloadWorkspacesButton.setVisible(this.isShowWorkspaces);
        List columns = this.isShowWorkspaces ? Arrays.asList(COLUMN_SERVER_WORKSPACE, COLUMN_COMMENT) : Collections.singletonList(COLUMN_SERVER);
        this.treeTable.initialize(columns, this.contentProvider);
        this.treeTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.treeTable.expandAll();
    }

    public void updateControls(Object selectedServerOrWorkspace) {
        this.logger.info("Updating Manage Workspaces controls");
        this.treeTable.updateContent();
        this.treeTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.treeTable.expandAll();
        Object newSelection = null;
        for (int i = 0; i < this.treeTable.getModel().getRowCount(); ++i) {
            Workspace workspace2;
            Workspace workspace1;
            Object o = ((DefaultMutableTreeNode)this.treeTable.getModel().getValueAt(i, 0)).getUserObject();
            if (selectedServerOrWorkspace instanceof Server && o instanceof Server) {
                Server server1 = (Server)selectedServerOrWorkspace;
                Server server2 = (Server)o;
                if (StringUtils.equals((String)server1.getName(), (String)server2.getName())) {
                    newSelection = o;
                    break;
                }
            }
            if (!(selectedServerOrWorkspace instanceof Workspace) || !(o instanceof Workspace) || !(workspace1 = (Workspace)selectedServerOrWorkspace).equals((Object)(workspace2 = (Workspace)o))) continue;
            newSelection = o;
            break;
        }
        this.treeTable.select(newSelection);
    }

    private void updateButtons() {
        Server selectedServer = this.getSelectedServer();
        Workspace selectedWorkspace = this.getSelectedWorkspace();
        this.proxySettingsButton.setEnabled(selectedServer != null);
        this.editWorkspaceButton.setEnabled(selectedWorkspace != null);
        this.deleteWorkspaceButton.setEnabled(selectedWorkspace != null);
        this.reloadWorkspacesButton.setEnabled(selectedServer != null);
    }

    @Nullable
    private Object getSelectedObject() {
        Collection<Object> selection;
        if (this.treeTable.getSelectedRowCount() == 1 && (selection = this.treeTable.getSelectedItems()).size() == 1) {
            return this.treeTable.getSelectedItems().iterator().next();
        }
        return null;
    }

    @Nullable
    public Workspace getSelectedWorkspace() {
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof Workspace) {
            return (Workspace)selectedObject;
        }
        return null;
    }

    @Nullable
    public Server getSelectedServer() {
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof Server) {
            return (Server)selectedObject;
        }
        return null;
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.treeTable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel2;
        this.createUIComponents();
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 7, null, null, null));
        CustomTreeTable<Object> customTreeTable = this.treeTable;
        jBScrollPane.setViewportView((Component)((Object)customTreeTable));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Tfvc.ManageWorkspaces.Accounts.Panel.Title"), 0, 0, null, null));
        this.reloadWorkspacesButton = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Tfvc.ManageWorkspaces.Reload.Button"));
        jPanel3.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.proxySettingsButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Tfvc.ManageWorkspaces.Proxy.Button"));
        jPanel3.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.workspacesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Tfvc.ManageWorkspaces.Workspaces.Panel.Title"), 0, 0, null, null));
        this.editWorkspaceButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Tfvc.ManageWorkspaces.Edit.Button"));
        jPanel.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.deleteWorkspaceButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Tfvc.ManageWorkspaces.Delete.Button"));
        jPanel.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class CellRendererImpl
    extends CellRenderer<Object> {
        private CellRendererImpl() {
        }

        @Override
        protected void render(CustomTreeTable<Object> treeTable, TreeTableColumn<Object> column, Object value, JLabel cell) {
            super.render(treeTable, column, value, cell);
            if (column == COLUMN_SERVER_WORKSPACE || column == COLUMN_SERVER) {
                if (value instanceof Server) {
                    if (UrlHelper.isTeamServicesUrl((String)((Server)value).getName())) {
                        cell.setIcon(Icons.CLOUD);
                    } else {
                        cell.setIcon(Icons.SERVER);
                    }
                } else if (value instanceof Workspace) {
                    cell.setIcon(Icons.TFVC_LOGO);
                }
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void selectionChanged();
    }
}

