/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.management;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.external.exceptions.ToolAuthenticationException;
import com.microsoft.alm.plugin.external.models.Server;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.external.utils.WorkspaceHelper;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractModel;
import com.microsoft.alm.plugin.idea.common.ui.common.treetable.ContentProvider;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.tfvc.ui.ProxySettingsDialog;
import com.microsoft.alm.plugin.idea.tfvc.ui.workspace.WorkspaceController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageWorkspacesModel
extends AbstractModel {
    private final Logger logger = LoggerFactory.getLogger(ManageWorkspacesModel.class);
    public static final String REFRESH_SERVER = "refreshServer";
    public static final String REFRESH_WORKSPACE = "refreshWorkspace";
    private final Project project;
    private final ContentProvider<Object> contentProvider;

    public ManageWorkspacesModel(Project project) {
        this.project = project;
        this.contentProvider = new ServerWorkspaceContentProvider();
    }

    public ContentProvider<Object> getContextProvider() {
        return this.contentProvider;
    }

    public void reloadWorkspacesWithProgress(final Server selectedServer) {
        this.logger.info("Reloading workspaces for server " + selectedServer.getName());
        try {
            VcsUtil.runVcsProcessWithProgress((VcsRunnable)new VcsRunnable(){

                public void run() throws VcsException {
                    ManageWorkspacesModel.this.reloadWorkspaces(selectedServer);
                }
            }, (String)TfPluginBundle.message("Tfvc.ManageWorkspaces.Reload.Msg", selectedServer.getName()), (boolean)true, (Project)this.project);
        }
        catch (VcsException e) {
            this.logger.warn("Exception while trying to reload workspaces", (Throwable)e);
            Messages.showErrorDialog((Project)this.project, (String)e.getMessage(), (String)TfPluginBundle.message("Tfvc.ManageWorkspaces.Reload.Error.Title", new Object[0]));
        }
        finally {
            this.setChangedAndNotify(REFRESH_SERVER);
        }
    }

    protected void reloadWorkspaces(Server selectedServer) throws VcsException {
        try {
            AuthenticationInfo authInfo = ServerContextManager.getInstance().getAuthenticationInfo(selectedServer.getName(), true);
            if (authInfo == null) {
                this.logger.warn("Couldn't get auth info so aborting reload command");
                throw new RuntimeException(TfPluginBundle.message("Tfvc.ManageWorkspaces.Reload.Error.Msg", selectedServer.getName()));
            }
            CommandUtils.refreshWorkspacesForServer((AuthenticationInfo)authInfo, (String)selectedServer.getName());
        }
        catch (RuntimeException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public void deleteWorkspaceWithProgress(final Workspace selectedWorkspace) {
        this.logger.info("Deleting workspace " + selectedWorkspace.getName());
        if (Messages.showYesNoDialog((Project)this.project, (String)TfPluginBundle.message("Tfvc.ManageWorkspaces.Delete.Confirm.Msg", selectedWorkspace.getName()), (String)TfPluginBundle.message("Tfvc.ManageWorkspaces.Delete.Confirm.Title", new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            this.logger.info("User cancelled workspace delete");
            return;
        }
        try {
            VcsUtil.runVcsProcessWithProgress((VcsRunnable)new VcsRunnable(){

                public void run() throws VcsException {
                    ManageWorkspacesModel.this.deleteWorkspace(selectedWorkspace);
                }
            }, (String)TfPluginBundle.message("Tfvc.ManageWorkspaces.Delete.Msg", selectedWorkspace.getName()), (boolean)true, (Project)this.project);
        }
        catch (VcsException e) {
            this.logger.warn("Exception while trying to delete workspace", (Throwable)e);
            Messages.showErrorDialog((Project)this.project, (String)e.getMessage(), (String)TfPluginBundle.message("Tfvc.ManageWorkspaces.Delete.Error.Title", new Object[0]));
        }
        finally {
            this.setChangedAndNotify(REFRESH_WORKSPACE);
        }
    }

    protected void deleteWorkspace(Workspace selectedWorkspace) throws VcsException {
        try {
            Workspace workspace = this.getPartialWorkspace(selectedWorkspace.getServer(), selectedWorkspace.getName());
            if (workspace == null) {
                this.logger.warn("Couldn't find partial workspace so aborting delete command");
                throw new RuntimeException(TfPluginBundle.message(TfPluginBundle.message("Tfvc.ManageWorkspaces.Delete.Error.Msg", selectedWorkspace.getName()), new Object[0]));
            }
            String projectName = VcsHelper.getTeamProjectFromTfvcServerPath(workspace.getMappings().size() > 0 ? ((Workspace.Mapping)workspace.getMappings().get(0)).getServerPath() : null);
            ServerContext context = ServerContextManager.getInstance().createContextFromTfvcServerUrl(workspace.getServer(), projectName, true);
            CommandUtils.deleteWorkspace((ServerContext)context, (String)selectedWorkspace.getName());
        }
        catch (RuntimeException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public void editWorkspaceWithProgress(final Workspace selectedWorkspace, final Runnable update) {
        this.logger.info("Editing workspace " + selectedWorkspace.getName());
        try {
            VcsUtil.runVcsProcessWithProgress((VcsRunnable)new VcsRunnable(){

                public void run() throws VcsException {
                    ManageWorkspacesModel.this.editWorkspace(selectedWorkspace, update);
                }
            }, (String)TfPluginBundle.message("Tfvc.ManageWorkspaces.Edit.Msg", selectedWorkspace.getName()), (boolean)true, (Project)this.project);
        }
        catch (VcsException e) {
            this.logger.warn("Exception while trying to edit workspace", (Throwable)e);
            Messages.showErrorDialog((Project)this.project, (String)e.getMessage(), (String)TfPluginBundle.message("Tfvc.ManageWorkspaces.Edit.Error.Title", new Object[0]));
        }
    }

    protected void editWorkspace(Workspace selectedWorkspace, final Runnable update) throws VcsException {
        try {
            Workspace workspace;
            ServerContext context;
            AuthenticationInfo authInfo = ServerContextManager.getInstance().getAuthenticationInfo(selectedWorkspace.getServer(), true);
            Workspace detailedWorkspace = CommandUtils.getDetailedWorkspace((String)selectedWorkspace.getServer(), (String)selectedWorkspace.getName(), (AuthenticationInfo)authInfo);
            if (detailedWorkspace != null) {
                String projectName = VcsHelper.getTeamProjectFromTfvcServerPath(detailedWorkspace.getMappings().size() > 0 ? ((Workspace.Mapping)detailedWorkspace.getMappings().get(0)).getServerPath() : null);
                context = ServerContextManager.getInstance().createContextFromTfvcServerUrl(detailedWorkspace.getServer(), projectName, true);
                workspace = new Workspace(selectedWorkspace.getServer(), selectedWorkspace.getName(), selectedWorkspace.getComputer(), selectedWorkspace.getOwner(), selectedWorkspace.getComment(), detailedWorkspace.getMappings(), detailedWorkspace.getLocation());
                if (context == null || workspace == null) {
                    this.logger.warn(String.format("Can't edit workspace because context is null: %s or workspace is null: %s", context == null, workspace == null));
                    throw new RuntimeException(TfPluginBundle.message(TfPluginBundle.message("Tfvc.ManageWorkspaces.Edit.Error.Msg", selectedWorkspace.getName()), new Object[0]));
                }
            } else {
                this.logger.warn("Couldn't find partial workspace so aborting edit command");
                throw new RuntimeException(TfPluginBundle.message(TfPluginBundle.message("Tfvc.ManageWorkspaces.Edit.Error.Msg", selectedWorkspace.getName()), new Object[0]));
            }
            IdeaHelper.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    WorkspaceController controller = new WorkspaceController(ManageWorkspacesModel.this.project, context, workspace);
                    if (controller.showModalDialog(false)) {
                        controller.saveWorkspace("", false, update);
                    }
                }
            }, true);
        }
        catch (RuntimeException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public void editProxy(Server selectedServer) {
        this.logger.info("Editing proxy for " + selectedServer.getName());
        String currentProxy = this.getProxy(selectedServer);
        ProxySettingsDialog dialog = new ProxySettingsDialog(this.project, selectedServer.getName(), currentProxy);
        if (dialog.showAndGet()) {
            String newProxy = dialog.getProxyUri();
            this.setProxy(selectedServer, newProxy);
            this.setChangedAndNotify(REFRESH_SERVER);
        }
    }

    private String getProxy(Server server) {
        return WorkspaceHelper.getProxyServer((String)server.getName());
    }

    private void setProxy(Server server, String newProxy) {
        WorkspaceHelper.setProxyServer((String)server.getName(), (String)newProxy);
    }

    protected Workspace getPartialWorkspace(String serverName, String workspaceName) {
        try {
            return CommandUtils.getPartialWorkspace((String)serverName, (String)workspaceName);
        }
        catch (ToolAuthenticationException e) {
            this.logger.warn("Authentication failed while trying to get the partial workspace. Trying again with credentials");
            AuthenticationInfo authInfo = ServerContextManager.getInstance().getAuthenticationInfo(serverName, true);
            return CommandUtils.getPartialWorkspace((String)serverName, (String)workspaceName, (AuthenticationInfo)authInfo);
        }
    }

    protected class ServerWorkspaceContentProvider
    implements ContentProvider {
        protected ServerWorkspaceContentProvider() {
        }

        public Collection<?> getRoots() {
            ArrayList servers = new ArrayList(CommandUtils.getAllWorkspaces(null));
            Collections.sort(servers, new Comparator<Server>(){

                @Override
                public int compare(Server s1, Server s2) {
                    return s1.getName().compareTo(s2.getName());
                }
            });
            return servers;
        }

        public Collection<?> getChildren(@NotNull Object parent) {
            if (parent == null) {
                ServerWorkspaceContentProvider.$$$reportNull$$$0(0);
            }
            if (parent instanceof Server) {
                ArrayList workspaces = new ArrayList(((Server)parent).getWorkspaces());
                Collections.sort(workspaces, new Comparator<Workspace>(){

                    @Override
                    public int compare(Workspace w1, Workspace w2) {
                        return w1.getName().compareTo(w2.getName());
                    }
                });
                return workspaces;
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/microsoft/alm/plugin/idea/tfvc/ui/management/ManageWorkspacesModel$ServerWorkspaceContentProvider", "getChildren"));
        }
    }
}

