/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.resolve;

import com.microsoft.alm.plugin.external.models.Conflict;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ConflictsTableModel
extends AbstractTableModel {
    private List<Conflict> myConflicts = new ArrayList<Conflict>();

    @Override
    public String getColumnName(int column) {
        return Column.values()[column].getCaption();
    }

    @Override
    public int getRowCount() {
        return this.myConflicts != null ? this.myConflicts.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Conflict conflict = this.myConflicts.get(rowIndex);
        return Column.values()[columnIndex].getValue(conflict);
    }

    public void setConflicts(List<Conflict> conflicts) {
        this.myConflicts.clear();
        this.myConflicts.addAll(conflicts);
        this.fireTableDataChanged();
    }

    public List<Conflict> getMyConflicts() {
        return this.myConflicts;
    }

    public static enum Column {
        Name(TfPluginBundle.message("Tfvc.Conflict.Column.Name", new Object[0])){

            @Override
            public String getValue(Conflict conflict) {
                return conflict.getLocalPath();
            }
        }
        ,
        Type(TfPluginBundle.message("Tfvc.Conflict.Column.Type", new Object[0])){

            @Override
            public String getValue(Conflict conflict) {
                switch (conflict.getType()) {
                    case CONTENT: {
                        return TfPluginBundle.message("Tfvc.Conflict.Column.Type.Content", new Object[0]);
                    }
                    case RENAME: {
                        return TfPluginBundle.message("Tfvc.Conflict.Column.Type.Rename", new Object[0]);
                    }
                    case NAME_AND_CONTENT: {
                        return TfPluginBundle.message("Tfvc.Conflict.Column.Type.NameAndContent", new Object[0]);
                    }
                    case MERGE: {
                        return TfPluginBundle.message("Tfvc.Conflict.Column.Type.Merge", new Object[0]);
                    }
                    case DELETE: {
                        return TfPluginBundle.message("Tfvc.Conflict.Column.Type.Delete", new Object[0]);
                    }
                    case DELETE_TARGET: {
                        return TfPluginBundle.message("Tfvc.Conflict.Column.Type.DeleteTarget", new Object[0]);
                    }
                    case RESOLVED: {
                        return TfPluginBundle.message("Tfvc.Conflict.Column.Type.Resolved", new Object[0]);
                    }
                }
                return "";
            }
        };

        private final String myCaption;

        private Column(String caption) {
            this.myCaption = caption;
        }

        public String getCaption() {
            return this.myCaption;
        }

        public abstract String getValue(Conflict var1);
    }
}

