/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.BasicForm;
import com.microsoft.alm.plugin.idea.tfvc.ui.resolve.ConflictsTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.annotations.NonNls;

public class ResolveConflictsForm
implements BasicForm {
    @VisibleForTesting
    protected JTable myItemsTable;
    private JPanel myContentPanel;
    @VisibleForTesting
    protected JButton myAcceptYoursButton;
    @VisibleForTesting
    protected JButton myAcceptTheirsButton;
    @VisibleForTesting
    protected JButton myMergeButton;
    private boolean initialized = false;
    private boolean isLoading = false;
    @NonNls
    public static final String CMD_MERGE = "merge";
    @NonNls
    public static final String CMD_ACCEPT_YOURS = "acceptYours";
    @NonNls
    public static final String CMD_ACCEPT_THEIRS = "acceptTheirs";

    public ResolveConflictsForm() {
        this.$$$setupUI$$$();
        this.myItemsTable.setSelectionMode(2);
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.myContentPanel;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.myAcceptYoursButton.setText(TfPluginBundle.message("Tfvc.Conflict.Dialog.AcceptYours", new Object[0]));
            this.myAcceptTheirsButton.setText(TfPluginBundle.message("Tfvc.Conflict.Dialog.AcceptTheirs", new Object[0]));
            this.myMergeButton.setText(TfPluginBundle.message("Tfvc.Conflict.Dialog.Merge", new Object[0]));
            this.myAcceptTheirsButton.setActionCommand(CMD_ACCEPT_THEIRS);
            this.myAcceptYoursButton.setActionCommand(CMD_ACCEPT_YOURS);
            this.myMergeButton.setActionCommand(CMD_MERGE);
            this.myItemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent se) {
                    int[] selectedIndices = ResolveConflictsForm.this.myItemsTable.getSelectedRows();
                    ResolveConflictsForm.this.enableButtons(selectedIndices);
                }
            });
            this.initialized = true;
        }
    }

    public void setModelForView(ConflictsTableModel conflictsTableModel) {
        this.myItemsTable.setModel(conflictsTableModel);
        if (this.myItemsTable.getColumnModel() != null && this.myItemsTable.getColumnModel().getColumnCount() > 1) {
            DefaultTableCellRenderer typeRenderer = new DefaultTableCellRenderer();
            typeRenderer.setHorizontalAlignment(0);
            this.myItemsTable.getColumnModel().getColumn(1).setCellRenderer(typeRenderer);
        }
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
        this.myItemsTable.setCellSelectionEnabled(!isLoading);
        if (isLoading) {
            this.myItemsTable.setForeground(Color.GRAY);
            this.myAcceptYoursButton.setEnabled(false);
            this.myAcceptTheirsButton.setEnabled(false);
            this.myMergeButton.setEnabled(false);
        } else {
            this.myItemsTable.setForeground(Color.BLACK);
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.myAcceptYoursButton.addActionListener(listener);
        this.myAcceptTheirsButton.addActionListener(listener);
        this.myMergeButton.addActionListener(listener);
    }

    @VisibleForTesting
    protected void enableButtons(int[] selectedIndices) {
        this.myAcceptYoursButton.setEnabled(!this.isLoading && selectedIndices.length > 0);
        this.myAcceptTheirsButton.setEnabled(!this.isLoading && selectedIndices.length > 0);
        this.myMergeButton.setEnabled(!this.isLoading && selectedIndices.length > 0);
    }

    public int[] getSelectedRows() {
        return this.myItemsTable.getSelectedRows();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myItemsTable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAcceptYoursButton = jButton3 = new JButton();
        ((Component)jButton3).setEnabled(false);
        jButton3.setText("Accept Yours");
        jButton3.setMnemonic('Y');
        jButton3.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAcceptTheirsButton = jButton2 = new JButton();
        ((Component)jButton2).setEnabled(false);
        jButton2.setText("Accept Theirs");
        jButton2.setMnemonic('T');
        jButton2.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMergeButton = jButton = new JButton();
        ((Component)jButton).setEnabled(false);
        jButton.setText("Merge");
        jButton.setMnemonic('M');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = new JBTable();
        this.myItemsTable = jBTable;
        jBTable.putClientProperty((Object)"Table.isFileList", (Object)Boolean.FALSE);
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

