/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.resolve;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.plugin.external.commands.ResolveConflictsCommand;
import com.microsoft.alm.plugin.external.models.Conflict;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.PageModelImpl;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.conflicts.ResolveConflictHelper;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.MergeFailedException;
import com.microsoft.alm.plugin.idea.tfvc.ui.resolve.ConflictsTableModel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveConflictsModel
extends PageModelImpl {
    private static final Logger logger = LoggerFactory.getLogger(ResolveConflictsModel.class);
    private final Project project;
    private final ConflictsTableModel conflictsTableModel;
    private final ResolveConflictHelper conflictHelper;

    public ResolveConflictsModel(Project project, ResolveConflictHelper conflictHelper) {
        this(project, conflictHelper, new ConflictsTableModel());
    }

    public ResolveConflictsModel(Project project, ResolveConflictHelper conflictHelper, ConflictsTableModel conflictsTableModel) {
        this.project = project;
        this.conflictHelper = conflictHelper;
        this.conflictsTableModel = conflictsTableModel;
    }

    public void loadConflicts() {
        logger.debug("Loading conflicts into the table");
        try {
            VcsRunnable resolveRunnable = new VcsRunnable(){

                public void run() throws VcsException {
                    IdeaHelper.setProgress(ProgressManager.getInstance().getProgressIndicator(), 0.1, TfPluginBundle.message("Tfvc.Conflict.Loading.Conflicts", new Object[0]));
                    ResolveConflictsModel.this.conflictHelper.findConflicts(ResolveConflictsModel.this);
                }
            };
            VcsUtil.runVcsProcessWithProgress((VcsRunnable)resolveRunnable, (String)TfPluginBundle.message("Tfvc.Conflict.Loading.ProgressBar", new Object[0]), (boolean)false, (Project)this.project);
        }
        catch (VcsException e) {
            logger.error("Error while loading conflicts: " + e.getMessage());
            this.addError(ModelValidationInfo.createWithMessage(TfPluginBundle.message("Tfvc.Conflict.Load.Error", new Object[0])));
        }
    }

    public void acceptYours(int[] rows) {
        logger.info("Accepting yours for " + rows.length + " conflicts");
        this.conflictHelper.acceptChangeAsync(this.getSelectedConflicts(rows), ResolveConflictsCommand.AutoResolveType.KeepYours, this);
    }

    public void acceptTheirs(int[] rows) {
        logger.info("Accepting theirs for " + rows.length + " conflicts");
        this.conflictHelper.acceptChangeAsync(this.getSelectedConflicts(rows), ResolveConflictsCommand.AutoResolveType.TakeTheirs, this);
    }

    public void merge(int[] rows) {
        List<Conflict> conflicts = this.getSelectedConflicts(rows);
        logger.info("Starting merge...");
        for (Conflict conflict : conflicts) {
            try {
                this.conflictHelper.acceptMerge(conflict, this);
            }
            catch (MergeFailedException e) {
                logger.warn("MergeFailedException found", (Throwable)((Object)e));
                this.addError(ModelValidationInfo.createWithMessage(e.getMessage()));
            }
            catch (VcsException e) {
                logger.warn("Error while merging conflicts", (Throwable)e);
                this.addError(ModelValidationInfo.createWithMessage(TfPluginBundle.message("Tfvc.Conflict.Merge.Error", conflict.getLocalPath(), e.getMessage())));
            }
        }
    }

    public void processSkippedConflicts() {
        this.conflictHelper.skip(this.conflictsTableModel.getMyConflicts());
    }

    public ConflictsTableModel getConflictsTableModel() {
        return this.conflictsTableModel;
    }

    private List<Conflict> getSelectedConflicts(int[] rows) {
        ArrayList<Conflict> selectedConflicts = new ArrayList<Conflict>();
        for (int index : rows) {
            selectedConflicts.add(this.conflictsTableModel.getMyConflicts().get(index));
        }
        return selectedConflicts;
    }
}

