/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.servertree;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.TfsErrorTreeNode;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.TfsTreeNode;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public class TfsTreeBuilder
extends AbstractTreeBuilder {
    private static final Logger LOG = Logger.getInstance((String)TfsTreeBuilder.class.getName());
    private static final Comparator<NodeDescriptor> COMPARATOR = new Comparator<NodeDescriptor>(){

        @Override
        public int compare(NodeDescriptor o1, NodeDescriptor o2) {
            if (o1 instanceof TfsErrorTreeNode) {
                return o2 instanceof TfsErrorTreeNode ? ((TfsErrorTreeNode)o1).getMessage().compareTo(((TfsErrorTreeNode)o2).getMessage()) : -1;
            }
            if (o2 instanceof TfsErrorTreeNode) {
                return 1;
            }
            TfsTreeNode n1 = (TfsTreeNode)o1;
            TfsTreeNode n2 = (TfsTreeNode)o2;
            if (n1.isDirectory() && !n2.isDirectory()) {
                return -1;
            }
            if (!n1.isDirectory() && n2.isDirectory()) {
                return 1;
            }
            return n1.getFileName().compareToIgnoreCase(n2.getFileName());
        }
    };

    public static TfsTreeBuilder createInstance(@NotNull TfsTreeNode root, @NotNull JTree tree) {
        if (root == null) {
            TfsTreeBuilder.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            TfsTreeBuilder.$$$reportNull$$$0(1);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode((Object)root));
        tree.setModel(treeModel);
        return new TfsTreeBuilder(tree, treeModel, (AbstractTreeStructure)new SimpleTreeStructure.Impl(root){

            public boolean isToBuildChildrenInBackground(Object element) {
                return true;
            }

            public boolean isAlwaysLeaf(Object element) {
                if (element instanceof TfsTreeNode) {
                    return !((TfsTreeNode)((Object)element)).isDirectory();
                }
                LOG.assertTrue(element instanceof TfsErrorTreeNode);
                return true;
            }
        });
    }

    public TfsTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure) {
        super(tree, treeModel, treeStructure, COMPARATOR);
    }

    protected void runBackgroundLoading(@NotNull Runnable runnable) {
        if (runnable == null) {
            TfsTreeBuilder.$$$reportNull$$$0(2);
        }
        if (this.isDisposed()) {
            return;
        }
        runnable.run();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor instanceof TfsErrorTreeNode) {
            return true;
        }
        if (nodeDescriptor instanceof TfsTreeNode) {
            return !((TfsTreeNode)nodeDescriptor).isDirectory() || ((TfsTreeNode)nodeDescriptor).isRoot();
        }
        return false;
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        if (descriptor instanceof TfsTreeNode) {
            return ((TfsTreeNode)descriptor).isDirectory();
        }
        LOG.assertTrue(descriptor instanceof TfsErrorTreeNode);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/microsoft/alm/plugin/idea/tfvc/ui/servertree/TfsTreeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runBackgroundLoading";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

