/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.servertree;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.TfsTreeBuilder;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.TfsTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.EventListener;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class TfsTreeForm
implements Disposable,
DataProvider {
    private boolean canCreateVirtualFolders;
    public static final DataKey<TfsTreeForm> KEY = DataKey.create((String)"TfsTreeForm");
    public static final String POPUP_ACTION_GROUP = "TfvcTreePopupMenu";
    public static final Icon EMPTY_ICON = new EmptyIcon(0, UIUtil.getBalloonWarningIcon().getIconHeight());
    private JComponent contentPane;
    private Tree tree;
    private JTextField pathField;
    private JLabel messageLabel;
    private JPanel messagePanel;
    private TfsTreeBuilder treeBuider;
    private EventDispatcher<SelectionListener> eventDispatcher;
    private SelectedItem selectedItem;

    public TfsTreeForm() {
        this.$$$setupUI$$$();
        this.eventDispatcher = EventDispatcher.create(SelectionListener.class);
        DataManager.registerDataProvider((JComponent)this.tree, (DataProvider)this);
        new TreeSpeedSearch((JTree)this.tree);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TfsTreeForm.this.selectedItem = TfsTreeForm.this.doGetSelectedItem();
                TfsTreeForm.this.pathField.setText(TfsTreeForm.this.selectedItem != null ? ((TfsTreeForm)TfsTreeForm.this).selectedItem.path : null);
                ((SelectionListener)TfsTreeForm.this.eventDispatcher.getMulticaster()).selectionChanged();
            }
        });
        PopupHandler.installPopupHandler((JComponent)this.tree, (String)POPUP_ACTION_GROUP, (String)"RemoteHostDialogPopup");
        this.setMessage(null, false);
    }

    @Nullable
    public SelectedItem getSelectedItem() {
        return this.selectedItem;
    }

    @Nullable
    public String getSelectedPath() {
        return this.selectedItem != null ? this.selectedItem.path : null;
    }

    @Nullable
    private SelectedItem doGetSelectedItem() {
        Set selection = this.treeBuider.getSelectedElements();
        if (selection.isEmpty()) {
            return null;
        }
        Object o = selection.iterator().next();
        return o instanceof TfsTreeNode ? new SelectedItem((TfsTreeNode)((Object)o)) : null;
    }

    public void initialize(ServerContext serverContext, @Nullable String initialSelection, boolean foldersOnly, boolean canCreateVirtualFolders, @Nullable Condition<String> pathFilter) {
        this.canCreateVirtualFolders = canCreateVirtualFolders;
        TfsTreeNode root = new TfsTreeNode(this.tree, serverContext, initialSelection, foldersOnly, pathFilter);
        this.treeBuider = TfsTreeBuilder.createInstance(root, (JTree)this.tree);
        Disposer.register((Disposable)this, (Disposable)this.treeBuider);
        TfsTreeNode selection = root.createForSelection(initialSelection);
        if (selection != null) {
            this.treeBuider.select((Object)selection);
        }
    }

    public void addListener(SelectionListener selectionListener) {
        this.eventDispatcher.addListener((EventListener)selectionListener, (Disposable)this);
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.tree;
    }

    public void dispose() {
    }

    public Object getData(@NonNls String dataId) {
        if (KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    public void createVirtualFolder(String folderName) {
        Set selection = this.treeBuider.getSelectedElements();
        if (selection.isEmpty()) {
            return;
        }
        Object o = selection.iterator().next();
        if (!(o instanceof TfsTreeNode)) {
            return;
        }
        TfsTreeNode treeNode = (TfsTreeNode)((Object)o);
        final TfsTreeNode child = treeNode.createVirtualSubfolder(folderName);
        this.treeBuider.queueUpdateFrom((Object)treeNode, true).doWhenDone(new Runnable(){

            @Override
            public void run() {
                TfsTreeForm.this.treeBuider.select((Object)child);
            }
        });
    }

    public boolean canCreateVirtualFolders() {
        return this.canCreateVirtualFolders;
    }

    public void setMessage(String text, boolean error) {
        if (text != null) {
            this.messagePanel.setVisible(true);
            this.messageLabel.setText(text);
            this.messageLabel.setIcon(error ? UIUtil.getBalloonWarningIcon() : EMPTY_ICON);
        } else {
            this.messagePanel.setVisible(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JTextField jTextField;
        Tree tree;
        JPanel jPanel2 = new JPanel();
        this.contentPane = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.tree = tree = new Tree();
        jBScrollPane.setViewportView((Component)tree);
        this.pathField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.messagePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 2, null, new Dimension(11, 10), null));
        this.messageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public static class SelectedItem {
        public final String path;
        public final boolean isDirectory;

        public SelectedItem(String path, boolean idDirectory) {
            this.path = path;
            this.isDirectory = idDirectory;
        }

        public SelectedItem(TfsTreeNode treeNode) {
            this(treeNode.getPath(), treeNode.isDirectory());
        }
    }

    public static interface SelectionListener
    extends EventListener {
        public void selectionChanged();
    }
}

