/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.settings;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.external.tools.TfTool;
import com.microsoft.alm.plugin.external.utils.ProcessHelper;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EULADialog
extends DialogWrapper {
    private static final Logger logger = LoggerFactory.getLogger(EULADialog.class);
    private static boolean myWasShow = false;
    private final JBScrollPane myScrollPane;
    private final Boolean myEulaTextFound;

    private EULADialog(@Nullable Project project) {
        super(project);
        String eulaText = this.getEULAText();
        this.myEulaTextFound = eulaText != null;
        JTextArea textArea = new JTextArea();
        textArea.setText(eulaText);
        textArea.setMinimumSize(null);
        textArea.setEditable(false);
        textArea.setCaretPosition(0);
        textArea.setBackground(null);
        textArea.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane = new JBScrollPane((Component)textArea);
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        this.setModal(true);
        this.setTitle("Team Foundation Command-Line Client EULA");
        this.setOKButtonText("Accept");
        this.getOKAction().putValue("DefaultAction", null);
        this.setCancelButtonText("Decline");
        this.getCancelAction().putValue("DefaultAction", Boolean.TRUE);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getEULAText() {
        ZipFile jarFile = null;
        InputStream eulaStream = null;
        String jarName = "com.microsoft.tfs.client.common.jar";
        try {
            String tfLocation = TfTool.getLocation();
            if (tfLocation == null) {
                String string = null;
                return string;
            }
            String path = Path.combine((String)Path.combine((String)Path.getDirectoryName((String)tfLocation), (String)"lib"), (String)jarName);
            jarFile = new JarFile(path);
            eulaStream = ((JarFile)jarFile).getInputStream(((JarFile)jarFile).getEntry("eula.txt"));
            String string = StreamUtil.readText((InputStream)eulaStream, (Charset)Charsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            logger.error("Cannot read EULA text from: " + jarName, (Throwable)e);
        }
        finally {
            if (eulaStream != null) {
                try {
                    eulaStream.close();
                }
                catch (IOException e) {
                    logger.error("Cannot eulaStream properly", (Throwable)e);
                }
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    logger.error("Cannot jarFile properly", (Throwable)e);
                }
            }
        }
        return null;
    }

    public void show() {
        if (this.myEulaTextFound.booleanValue()) {
            super.show();
        }
    }

    public void doOKAction() {
        try {
            String tfLocation = TfTool.getLocation();
            Process process = ProcessHelper.startProcess((String)Path.getDirectoryName((String)tfLocation), Arrays.asList(tfLocation, "eula", SystemInfo.isWindows ? "/accept" : "-accept"));
            process.waitFor();
        }
        catch (Exception e) {
            logger.error("Can't accept EULA", (Throwable)e);
        }
        finally {
            super.doCancelAction();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myScrollPane;
    }

    public static synchronized void showDialogIfNeeded(Project project) {
        if (!myWasShow) {
            new EULADialog(project).showAndGet();
            myWasShow = true;
        }
    }
}

