/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.settings;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.microsoft.alm.plugin.external.exceptions.ToolException;
import com.microsoft.alm.plugin.external.exceptions.ToolVersionException;
import com.microsoft.alm.plugin.external.tools.TfTool;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public class ProjectConfigurableForm {
    private JButton myManageButton;
    private JButton myResetPasswordsButton;
    private final Project myProject;
    private JComponent myContentPane;
    private JCheckBox myUseIdeaHttpProxyCheckBox;
    private JCheckBox myTFSCheckBox;
    private JCheckBox myStatefulCheckBox;
    private JCheckBox myReportNotInstalledPoliciesCheckBox;
    private JPanel serverLabel;
    private JPanel passwordLabel;
    private JPanel checkinPolicyLabel;
    private JLabel noteLabel;
    private JButton testExeButton;
    private TextFieldWithBrowseButton tfExeField;
    private JLabel pathLabel;
    private HyperlinkLabel downloadLink;
    private JPanel downloadLinkPane;
    private String originalTfLocation = "";

    public ProjectConfigurableForm(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myResetPasswordsButton.setVisible(false);
        this.myUseIdeaHttpProxyCheckBox.setVisible(false);
        this.myTFSCheckBox.setVisible(false);
        this.myStatefulCheckBox.setVisible(false);
        this.myReportNotInstalledPoliciesCheckBox.setVisible(false);
        this.myResetPasswordsButton.setVisible(false);
        this.serverLabel.setVisible(false);
        this.passwordLabel.setVisible(false);
        this.checkinPolicyLabel.setVisible(false);
        this.noteLabel.setVisible(false);
        this.downloadLinkPane.setVisible(false);
        this.downloadLink.setHyperlinkText(TfPluginBundle.message("Tfvc.Settings.LinkLabel", new Object[0]), TfPluginBundle.message("Tfvc.Settings.LinkText", new Object[0]), "");
        this.downloadLink.setHyperlinkTarget(TfPluginBundle.message("Tfvc.Settings.LinkUrl", new Object[0]));
        this.downloadLink.setToolTipText(TfPluginBundle.message("Tfvc.Settings.LinkUrl", new Object[0]));
        this.pathLabel.setText(TfPluginBundle.message("Tfvc.Settings.Description", new Object[0]));
        this.tfExeField.addBrowseFolderListener(TfPluginBundle.message("Tfvc.Settings.Title", new Object[0]), TfPluginBundle.message("Tfvc.Settings.Description", new Object[0]), project, new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter((Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                return virtualFile.getName().equalsIgnoreCase(SystemInfo.isWindows ? "tf.cmd" : "tf");
            }
        }));
        this.testExeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String tfCmdPath = ProjectConfigurableForm.this.tfExeField.getText();
                if (StringUtils.isEmpty((String)tfCmdPath)) {
                    Messages.showErrorDialog((Component)ProjectConfigurableForm.this.myContentPane, (String)TfPluginBundle.message("Tfvc.Settings.Path.Empty", new Object[0]), (String)TfPluginBundle.message("Tfvc.tf.VersionWarning.Title", new Object[0]));
                    ProjectConfigurableForm.this.downloadLink.setVisible(true);
                    return;
                }
                File tfCmdFile = new File(tfCmdPath);
                if (!tfCmdFile.exists() || !tfCmdFile.isFile()) {
                    Messages.showErrorDialog((Component)ProjectConfigurableForm.this.myContentPane, (String)TfPluginBundle.message("Tfvc.Settings.Path.NotFound", tfCmdPath), (String)TfPluginBundle.message("Tfvc.tf.VersionWarning.Title", new Object[0]));
                    ProjectConfigurableForm.this.downloadLink.setVisible(true);
                    return;
                }
                PluginServiceProvider.getInstance().getPropertyService().setProperty("tfHome", ProjectConfigurableForm.this.getCurrentExecutablePath());
                try {
                    TfTool.checkVersion();
                    Messages.showInfoMessage((Component)ProjectConfigurableForm.this.myContentPane, (String)TfPluginBundle.message("Tfvc.Settings.FoundExe", new Object[0]), (String)TfPluginBundle.message("Tfvc.tf.VersionWarning.Title", new Object[0]));
                    ProjectConfigurableForm.this.downloadLinkPane.setVisible(false);
                }
                catch (ToolVersionException e) {
                    Messages.showWarningDialog((Component)ProjectConfigurableForm.this.myContentPane, (String)LocalizationServiceImpl.getInstance().getExceptionMessage(e), (String)TfPluginBundle.message("Tfvc.tf.VersionWarning.Title", new Object[0]));
                    ProjectConfigurableForm.this.downloadLinkPane.setVisible(true);
                }
                catch (ToolException e) {
                    Messages.showErrorDialog((Component)ProjectConfigurableForm.this.myContentPane, (String)LocalizationServiceImpl.getInstance().getExceptionMessage(e), (String)TfPluginBundle.message("Tfvc.tf.VersionWarning.Title", new Object[0]));
                    ProjectConfigurableForm.this.downloadLinkPane.setVisible(true);
                }
                catch (RuntimeException e) {
                    Messages.showErrorDialog((Component)ProjectConfigurableForm.this.myContentPane, (String)LocalizationServiceImpl.getInstance().getExceptionMessage(e), (String)TfPluginBundle.message("Tfvc.tf.VersionWarning.Title", new Object[0]));
                    ProjectConfigurableForm.this.downloadLinkPane.setVisible(true);
                }
            }
        });
        this.load();
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    @VisibleForTesting
    protected String getCurrentExecutablePath() {
        return this.tfExeField.getText().trim();
    }

    public void load() {
        String tfLocation = PluginServiceProvider.getInstance().getPropertyService().getProperty("tfHome");
        tfLocation = StringUtils.isEmpty((String)tfLocation) ? TfTool.tryDetectTf() : tfLocation;
        String string = this.originalTfLocation = StringUtils.isEmpty((String)tfLocation) ? "" : tfLocation;
        if (StringUtils.isEmpty((String)this.originalTfLocation)) {
            this.downloadLinkPane.setVisible(true);
        }
        this.tfExeField.setText(this.originalTfLocation);
    }

    public void apply() {
        PluginServiceProvider.getInstance().getPropertyService().setProperty("tfHome", this.getCurrentExecutablePath());
    }

    public boolean isModified() {
        return !PluginServiceProvider.getInstance().getPropertyService().getProperty("tfHome").equals(this.getCurrentExecutablePath());
    }

    public void reset() {
        PluginServiceProvider.getInstance().getPropertyService().setProperty("tfHome", this.originalTfLocation);
        this.tfExeField.setText(this.originalTfLocation);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JButton jButton2;
        JPanel jPanel3;
        JCheckBox jCheckBox4;
        JButton jButton3;
        JPanel jPanel4;
        JPanel jPanel5 = new JPanel();
        this.myContentPane = jPanel5;
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.serverLabel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Servers and workspaces", 0, 0, null, null));
        this.myManageButton = jButton3 = new JButton();
        jButton3.setText("Manage...");
        jButton3.setMnemonic('M');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myUseIdeaHttpProxyCheckBox = jCheckBox4 = new JCheckBox();
        ((Component)jCheckBox4).setEnabled(true);
        jCheckBox4.setSelected(false);
        jCheckBox4.setText("Use HTTP Proxy settings");
        jCheckBox4.setMnemonic('U');
        jCheckBox4.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.passwordLabel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Passwords", 0, 0, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myResetPasswordsButton = jButton2 = new JButton();
        jButton2.setText("Reset Saved Passwords");
        jButton2.setMnemonic('R');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.checkinPolicyLabel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Checkin policies compatibility", 0, 0, null, null));
        this.myReportNotInstalledPoliciesCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Warn about not installed policies");
        jCheckBox3.setMnemonic('W');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.noteLabel = jLabel2 = new JLabel();
        jLabel2.setText("(Note: these settings may be overridden for individual team project)");
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTFSCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Evaluate Team Explorer policies");
        jCheckBox2.setMnemonic('T');
        jCheckBox2.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myStatefulCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Evaluate Teamprise policies");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(10);
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.pathLabel = jLabel = new JLabel();
        jLabel.setText("Path to tf executable:");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tfExeField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.testExeButton = jButton = new JButton();
        jButton.setText("Test");
        jPanel5.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 2, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.downloadLinkPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.downloadLink = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

