/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.containers.HashMap;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListener;
import com.microsoft.alm.plugin.idea.tfvc.ui.workspace.WorkspaceForm;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;

public class WorkspaceDialog
extends BaseDialogImpl {
    private static final String PROP_SERVER_CONTEXT = "server_context";
    private WorkspaceForm workspaceForm;

    public WorkspaceDialog(Project project, ServerContext serverContext) {
        super(project, TfPluginBundle.message("WorkspaceDialog.Title", new Object[0]), TfPluginBundle.message("WorkspaceDialog.SaveButton", new Object[0]), "WorkspaceDialog.Title", true, WorkspaceDialog.createProperties(serverContext));
    }

    private static Map<String, Object> createProperties(ServerContext serverContext) {
        HashMap properties = new HashMap(4);
        properties.put(PROP_SERVER_CONTEXT, serverContext);
        return properties;
    }

    public JComponent getComponent(String componentPropName) {
        if (StringUtils.isEmpty((String)componentPropName) || this.workspaceForm == null) {
            return null;
        }
        return this.workspaceForm.getComponent(componentPropName);
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        if (this.workspaceForm != null) {
            return this.workspaceForm.getPreferredFocusedComponent();
        }
        return super.getPreferredFocusedComponent();
    }

    @Override
    protected JComponent createCenterPanel() {
        if (this.workspaceForm == null) {
            this.workspaceForm = new WorkspaceForm(this.getProject(), (ServerContext)this.getProperty(PROP_SERVER_CONTEXT), new ValidationListener(){

                @Override
                public ValidationInfo doValidate() {
                    WorkspaceDialog.this.validate();
                    return null;
                }
            });
        }
        return this.workspaceForm.getContentPane();
    }

    public String getFirstMappingValidationError() {
        return this.workspaceForm.getFirstMappingValidationError();
    }

    public String getWorkspaceName() {
        return this.workspaceForm.getWorkspaceName();
    }

    public String getWorkspaceComment() {
        return this.workspaceForm.getComment();
    }

    public List<Workspace.Mapping> getWorkingFolders() {
        return this.workspaceForm.getMappings();
    }

    public void setComment(String comment) {
        this.workspaceForm.setComment(comment);
    }

    public void setComputer(String computer) {
        this.workspaceForm.setComputer(computer);
    }

    public void setLoading(boolean loading) {
        this.workspaceForm.setLoading(loading);
    }

    public void setMappings(List<Workspace.Mapping> mappings) {
        this.workspaceForm.setMappings(mappings);
    }

    public void setName(String name) {
        this.workspaceForm.setWorkspaceName(name);
    }

    public void setOwner(String owner) {
        this.workspaceForm.setOwner(owner);
    }

    public void setServer(String server) {
        this.workspaceForm.setServer(server);
    }

    public void setLocation(Workspace.Location location) {
        this.workspaceForm.setLocation(location);
    }
}

